<div class="app-sidebar colored">
    <div class="sidebar-header">
        <a class="header-brand" href="{{ route('dashboard') }}">
            <!-- <div class="logo-img">
                <img height="30" src="{{ asset('img/logo_white.png') }}" class="header-brand-img" title="RADMIN"> 
            </div> -->
        </a>
        <div class="sidebar-action"><i class="ik ik-arrow-left-circle"></i></div>
        <button id="sidebarClose" class="nav-close"><i class="ik ik-x"></i></button>
    </div>

    @php
        $segment1 = request()->segment(1);
        $segment2 = request()->segment(2);
    @endphp

    <div class="sidebar-content">
        <div class="nav-container">
            <nav id="main-menu-navigation" class="navigation-main">

                <!-- Dashboard -->
                <div class="nav-item {{ $segment1 == 'dashboard' ? 'active' : '' }}">
                    <a href="{{ route('dashboard') }}"><i class="ik ik-bar-chart-2"></i><span>{{ __('Dashboard') }}</span></a>
                </div>

                <!-- Incident -->
                <div class="nav-item {{ $segment1 == 'incidents' ? 'active open' : '' }} has-sub">
                    <a href="javascript:void(0)"><i class="ik ik-alert-triangle"></i><span>{{ __('Incident') }}</span></a>
                    <div class="submenu-content">
                        <a href="{{ route('incidents.index') }}" class="menu-item {{ $segment1 == 'incidents' && !$segment2 ? 'active' : '' }}">{{ __('Incident List') }}</a>
                        <a href="{{ route('incidents.create') }}" class="menu-item {{ $segment1 == 'incidents' && $segment2 == 'create' ? 'active' : '' }}">{{ __('Register Incident') }}</a>
                    </div>
                </div>

                <!-- Manage Users -->
                 <div class="nav-item {{ ($segment1 == 'users' || $segment1 == 'roles'||$segment1 == 'permission' ||$segment1 == 'user') ? 'active open' : '' }} has-sub">
                    <a href="#"><i class="ik ik-user"></i><span>{{ __('Manage Users')}}</span></a>
                    <div class="submenu-content">
                        <!-- only those have manage_user permission will get access -->
                        @can('manage_user')
                        <a href="{{url('users')}}" class="menu-item {{ ($segment1 == 'users') ? 'active' : '' }}">{{ __('Users')}}</a>
                        <a href="{{url('user/create')}}" class="menu-item {{ ($segment1 == 'user' && $segment2 == 'create') ? 'active' : '' }}">{{ __('Add User')}}</a>
                         @endcan
                         <!-- only those have manage_role permission will get access -->
                        @can('manage_roles')
                        <a href="{{url('roles')}}" class="menu-item {{ ($segment1 == 'roles') ? 'active' : '' }}">{{ __('Roles')}}</a>
                        @endcan
                        <!-- only those have manage_permission permission will get access -->
                        @can('manage_permission')
                        <a href="{{url('permission')}}" class="menu-item {{ ($segment1 == 'permission') ? 'active' : '' }}">{{ __('Permission')}}</a>
                        @endcan
                    </div>
                </div>

                <!-- Surveillance -->
                <div class="nav-item {{ $segment1 == 'camera-surveillance' ? 'active' : '' }}">
                    <a href="{{ url('camera-surveillance') }}"><i class="ik ik-camera"></i><span>{{ __('Camera Surveillance') }}</span></a>
                </div>

                <!-- Satellite -->
                <div class="nav-item {{ $segment1 == 'satellite-data' ? 'active' : '' }}">
                    <a href="{{ url('satellite-data') }}"><i class="ik ik-globe"></i><span>{{ __('Satellite Data') }}</span></a>
                </div>

                <!-- Drone -->
                <div class="nav-item {{ $segment1 == 'drone' ? 'active' : '' }}">
                    <a href="{{ url('drone') }}"><i class="ik ik-airplay"></i><span>{{ __('Drone') }}</span></a>
                </div>

                <!-- Settings -->
                <div class="nav-item {{ $segment1 == 'settings' ? 'active' : '' }}">
                    <a href="{{ url('settings') }}"><i class="ik ik-settings"></i><span>{{ __('Settings') }}</span></a>
                </div>

            </nav>
        </div>
    </div>
</div>
