<?php

use Illuminate\Http\Request;
use App\Http\Controllers\Api\V4\Auth\AuthController;
use App\Http\Controllers\Api\V4\{
    CategoryController,
    CustomerController,
    DeliveryController,
    DiscountController,
    InventoryController,
    ProductController,
    SalesController,
    StoreController,
    TableController,
    UserController,
    PurchaseController,
    ExpensesController,
    SupplierController,
    OnlineOrderController,
    IncidentController
};
/*
|--------------------------------------------------------------------------
| API Routes  V1 /api
|--------------------------------------------------------------------------
|
*/


Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});




    //Auth
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/register', [AuthController::class, 'register']);

    // GET: Fetch all incidents for user with optional sync timestamp
    Route::get('incident/get-updates', [IncidentController::class, 'getIncidents']);

    // POST: Sync incident (create or update)
    Route::post('/incidents/sync', [IncidentController::class, 'syncIncident']);


    // Category
    Route::post('/category/sync', [CategoryController::class, 'syncCategory']);
    Route::get('/category/get-updates', [CategoryController::class, 'fetchCategories']);


    // Customer
    Route::post('/customer/sync', [CustomerController::class, 'syncCustomer']);
    Route::get('/customer/get-updates', [CustomerController::class, 'fetchCustomers']);
    Route::get('/customer/debt-history', [CustomerController::class, 'getCustomerDebtHistory']);
    Route::post('/customer/debt-history/sync', [CustomerController::class, 'syncCustomerDebtHistory']);
    // Fetch Customer Debt Payment Logs
    Route::get('/customer-debt-payments', [CustomerController::class, 'getCustomerDebtPayments']);
    // Save or Update Customer Debt Payment Log
    Route::post('/customer-debt-payments/sync', [CustomerController::class, 'syncCustomerDebtPayment']);

    // Delivery
    Route::post('/delivery/sync', [DeliveryController::class, 'syncDelivery']);
    Route::get('/delivery/get-updates', [DeliveryController::class, 'getDeliveries']);

    // Discount
    Route::post('/discount/sync', [DiscountController::class, 'syncDiscount']);
    Route::get('/discount/get-updates', [DiscountController::class, 'fetchDiscounts']);

    // Inventory
    Route::post('/inventory/stock/sync', [InventoryController::class, 'syncStock']);
    Route::get('/inventory/stock/get-updates', [InventoryController::class, 'getStockUpdates']);
    Route::post('/inventory/history/sync', [InventoryController::class, 'syncHistory']);
    Route::get('/inventory/history/get-updates', [InventoryController::class, 'getHistoryUpdates']);

    // Product
    Route::post('/product/sync', [ProductController::class, 'syncProduct']);
    Route::get('/product/get-updates', [ProductController::class, 'getProducts']);

    // Sales
    Route::post('/sales/sync', [SalesController::class, 'syncSales']);
    Route::get('/sales/get-updates', [SalesController::class, 'fetchSales']);
    Route::post('/sales/data/sync', [SalesController::class, 'syncSalesData']);
    Route::get('/sales/data/get-updates', [SalesController::class, 'fetchSalesData']);

    // Store
    Route::post('/store/sync', [StoreController::class, 'syncStore']);
    Route::get('/store/get-updates', [StoreController::class, 'getStores']);
    Route::get('/stores/list', [StoreController::class, 'getStoresBySessionKey']);
    Route::post('/store/update', [StoreController::class, 'updateStore']); 
    Route::post('/store/delete', [StoreController::class, 'deleteStore']);
    Route::post('/store/create', [StoreController::class, 'createStore']);
    Route::get('/currencies', [StoreController::class, 'getCurrencies']); 



 

    // Table
    Route::post('/table/sync', [TableController::class, 'sync']);
    Route::get('/table/get-updates', [TableController::class, 'getUpdates']);

    // User
    Route::post('/user/sync', [UserController::class, 'sync']);
    Route::get('/user/get-updates', [UserController::class, 'getUser']); 
    Route::get('/plans', [UserController::class, 'getPlans']);
    Route::get('/user/profile', [UserController::class, 'getUserProfile']);
    Route::post('/user/profile/update', [UserController::class, 'updateUserProfile']);

    //Staff 
    Route::post('/staff/create', [UserController::class, 'createStaff']); 
    Route::get('/staff/details', [UserController::class, 'getStaffs']);  
    Route::post('/staff/update', [UserController::class, 'updateStaff']);
    Route::post('/staff/delete', [UserController::class, 'blockUser']);
    Route::get('/staff/search', [UserController::class, 'searchUsers']);
 
   //transactions
    Route::get('/transactions/history', [OnlineOrderController::class, 'getTransactionHistory']);
    





    // PURCHASE ROUTES
    Route::prefix('purchase')->group(function () {
        Route::post('/sync', [PurchaseController::class, 'sync']);
        Route::get('/get-updates', [PurchaseController::class, 'getUpdates']);
        Route::get('/history', [PurchaseController::class, 'getTransactionHistory']);
        Route::post('/create', [PurchaseController::class, 'storePurchase']);
        Route::get('/history', [PurchaseController::class, 'purchaseHistoryReport']);
        Route::post('/payment', [PurchaseController::class, 'makePayment']);


        Route::get('/show', [PurchaseController::class, 'getPurchaseDetails']);
        Route::get('/cancel', [PurchaseController::class, 'cancelPurchase']);
        Route::get('/stock', [PurchaseController::class, 'getPurchaseStock']);
        Route::get('/stock-history', [PurchaseController::class, 'getPurchaseStockHistory']);
    });
 
    // EXPENSES ROUTES
    Route::prefix('expenses')->group(function () {
        Route::post('/sync', [ExpensesController::class, 'sync']);
        Route::get('/get-updates', [ExpensesController::class, 'getUpdates']);
        Route::get('/history', [ExpensesController::class, 'getExpensesHistory']);
        Route::post('/create', [ExpensesController::class, 'storeExpense']);
        Route::get('/show', [ExpensesController::class, 'getExpenseDetails']);
        Route::get('/cancel', [ExpensesController::class, 'markExpenseInactive']);

    });

    // SUPPLIER ROUTES
    Route::prefix('supplier')->group(function () {
        Route::post('/sync', [SupplierController::class, 'sync']);
        Route::get('/get-updates', [SupplierController::class, 'getUpdates']);
        Route::get('/index', [SupplierController::class, 'getSuppliers']);

    });
 








