 

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Incident Reports</h4>
                    <div>
                        <a href="<?php echo e(route('incidents.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Register New Incident
                        </a>
                        <a href="<?php echo e(route('incidents.export')); ?>" class="btn btn-success">
                            <i class="fas fa-download"></i> Export CSV
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <!-- Filter Form -->
                    <form method="GET" action="<?php echo e(route('incidents.index')); ?>" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <input type="text" name="region" class="form-control" placeholder="Filter by Region" value="<?php echo e(request('region')); ?>">
                            </div>
                            <div class="col-md-3">
                                <input type="text" name="category" class="form-control" placeholder="Filter by Category" value="<?php echo e(request('category')); ?>">
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date')); ?>">
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="end_date" class="form-control" value="<?php echo e(request('end_date')); ?>">
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-outline-primary w-100">Filter</button>
                            </div>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Location</th>
                                    <th>Category</th>
                                    <th>Casualties</th>
                                    <th>Source</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $incidents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $incident): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($incident->id); ?></td>
                                        <td>
                                            <?php echo e($incident->day); ?>/<?php echo e($incident->month); ?>/<?php echo e($incident->year); ?>

                                            <br><small class="text-muted"><?php echo e($incident->hour); ?></small>
                                        </td>
                                        <td>
                                            <strong><?php echo e($incident->city_town); ?>, <?php echo e($incident->state); ?></strong>
                                            <br><small class="text-muted"><?php echo e($incident->country); ?></small>
                                        </td>
                                        <td>
                                            <span class="badge bg-info"><?php echo e($incident->incident_category); ?></span>
                                        </td>
                                        <td>
                                            <?php if($incident->deaths > 0): ?>
                                                <span class="badge bg-danger"><?php echo e($incident->deaths); ?> Deaths</span>
                                            <?php endif; ?>
                                            <?php if($incident->injured > 0): ?>
                                                <span class="badge bg-warning"><?php echo e($incident->injured); ?> Injured</span>
                                            <?php endif; ?>
                                            <?php if($incident->affected > 0): ?>
                                                <span class="badge bg-secondary"><?php echo e($incident->affected); ?> Affected</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(Str::limit($incident->source, 30)); ?></td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="<?php echo e(route('incidents.show', $incident)); ?>" class="btn btn-sm btn-outline-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('incidents.edit', $incident)); ?>" class="btn btn-sm btn-outline-warning">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('incidents.destroy', $incident)); ?>" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this incident?')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center">No incidents found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        <?php echo e($incidents->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bybluepa/public_html/asat.bybluepage.com/resources/views/incidents/index.blade.php ENDPATH**/ ?>