<?php

namespace App\Http\Controllers\API\V4;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Restorant;
use App\Models\SimpleDeliveryArea;
use Illuminate\Support\Facades\DB;

class DeliveryController extends Controller
{
    public function getDeliveries(Request $request)
    {
        $userKey = $request->query('UserKey');

        $user = User::where('id_session', $userKey)->first();
        if (!$user) {
            return response()->json([
                'status' => 'true',
                'errCode' => '00',
                'msg' => 'User Not Found'
            ]);
        }

        $master = User::where('phone_number', $user->master)->first();
        $company = Restorant::where('userz', $user->master)->first();

        if (!$company) {
            return response()->json([
                'status' => 'true',
                'errCode' => '02',
                'msg' => 'No Delivery'
            ]);
        }

        $deliveries = SimpleDeliveryArea::where('restaurant_id', $company->id)
            ->where('status', '0')
            ->get();

        if ($deliveries->isEmpty()) {
            return response()->json([
                'status' => 'true',
                'errCode' => '02',
                'msg' => 'No Delivery'
            ]);
        }

        $response = $deliveries->map(function ($x) {
            return [
                'local_id_delivery' => $x->local_id,
                'id_delivery' => $x->id,
                'name_delivery' => $x->name,
                'cost' => $x->cost,
                'showOnline' => $x->show_online,
                'status' => $x->status,
                'updated_at' => $x->updated_at_long,
            ];
        });

        return response()->json($response);
    }

    public function syncDelivery(Request $request)
    {
        $data = $request->all();
        $userKey = $request->query('UserKey');

        $user = User::where('id_session', $userKey)->first();
        if (!$user) {
            return response()->json([
                'status' => 'fail',
                'msg' => 'User not found'
            ]);
        }

        $company = Restorant::where('userz', $user->master)->first();
        $restaurantId = $data['showOnline'] == 1 ? $company->id : 1;

        $delivery = SimpleDeliveryArea::where('local_id', $data['local_id_delivery'])
            ->orWhere('id', $data['id_delivery'])
            ->first();

        if ($delivery) {
            if (!empty($data['updated_at']) && $delivery->updated_at >= $data['updated_at']) {
                return response()->json([['status' => 'success']]);
            }

            $delivery->update([
                'name' => $data['name_delivery'],
                'cost' => $data['cost'],
                'status' => $data['status'],
                'show_online' => $data['showOnline'],
                'restaurant_id' => $restaurantId,
                'updated_at' => $data['updated_at'],
                'local_id' => $data['local_id_delivery'],
            ]);

        } else {
            SimpleDeliveryArea::create([
                'local_id' => $data['local_id_delivery'],
                'name' => $data['name_delivery'],
                'cost' => $data['cost'],
                'restaurant_id' => $restaurantId,
                'show_online' => $data['showOnline'],
                'status' => $data['status'],
                'updated_at' => $data['updated_at'],
            ]);
        }

        return response()->json([['status' => 'success']]);
    }
}
