<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Hash;
use Laravel\Passport\HasApiTokens;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Permission\Traits\HasRoles;

class Incident extends Model
{
    use HasFactory;

    protected $fillable = [
        'year',
        'user_id',
        'month',
        'day',
        'hour',
        'region',
        'country',
        'state',
        'local_government',
        'city_town',
        'village',
        'sub_division_block',
        'road_exact_location',
        'latitude',
        'longitude',
        'incident_category',
        'main_victim',
        'government_involve',
        'civilian',
        'military',
        'nsag',
        'deaths',
        'injured',
        'affected',
        'perpetrator',
        'source',
        'time_before_attack',
        'action_taken',
        'by_who',
        'brief_narrative',
        'comment',
    ];

    protected $casts = [
        'government_involve' => 'boolean',
        'military' => 'boolean',
        'year' => 'integer',
        'day' => 'integer',
        'deaths' => 'integer',
        'injured' => 'integer',
        'affected' => 'integer',
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8',
    ];

    // Accessor for formatted date
    public function getFormattedDateAttribute()
    {
        return $this->year . '-' . str_pad($this->month, 2, '0', STR_PAD_LEFT) . '-' . str_pad($this->day, 2, '0', STR_PAD_LEFT);
    }

    // Scope for filtering by date range
    public function scopeByDateRange($query, $startDate, $endDate)
    {
        return $query->whereBetween('created_at', [$startDate, $endDate]);
    }

    // Scope for filtering by region
    public function scopeByRegion($query, $region)
    {
        return $query->where('region', $region);
    }

    // Scope for filtering by incident category
    public function scopeByCategory($query, $category)
    {
        return $query->where('incident_category', $category);
    }
}