@extends('layouts.main') 
@section('title', 'Security Command Center')

@section('content')
    <!-- Enhanced CSS and External Resources -->
    @push('head')
        <link rel="stylesheet" href="{{ asset('plugins/weather-icons/css/weather-icons.min.css') }}">
        <link rel="stylesheet" href="{{ asset('plugins/owl.carousel/dist/assets/owl.carousel.min.css') }}">
        <link rel="stylesheet" href="{{ asset('plugins/owl.carousel/dist/assets/owl.theme.default.min.css') }}">
        <link rel="stylesheet" href="{{ asset('plugins/chartist/dist/chartist.min.css') }}">
        
        <!-- Enhanced Security Dashboard Styles -->
        <style>
            :root {
                --primary-color: #2c3e50;
                --secondary-color: #3498db;
                --success-color: #27ae60;
                --warning-color: #f39c12;
                --danger-color: #e74c3c;
                --dark-bg: #1a1a1a;
                --card-bg: #ffffff;
                --text-dark: #2c3e50;
                --text-light: #7f8c8d;
                --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                --shadow-hover: 0 8px 25px rgba(0, 0, 0, 0.15);
            }

            /* Enhanced Body Styles */
            body {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            }

            /* Animated Page Header */
            .page-header {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                padding: 2rem 0;
                margin-bottom: 2rem;
                border-radius: 10px;
                box-shadow: var(--shadow);
                animation: slideInDown 0.8s ease-out;
            }

            .page-header h1 {
                font-size: 2.5rem;
                font-weight: 700;
                text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
            }

            /* Enhanced Card Styles */
            .card {
                border: none;
                border-radius: 15px;
                box-shadow: var(--shadow);
                transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
                overflow: hidden;
                margin-bottom: 2rem;
                background: var(--card-bg);
                animation: fadeInUp 0.6s ease-out;
            }

            .card:hover {
                transform: translateY(-5px);
                box-shadow: var(--shadow-hover);
            }

            /* Stat Cards with Gradient Backgrounds */
            .stat-card {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                position: relative;
                overflow: hidden;
                min-height: 140px;
            }

            .stat-card::before {
                content: '';
                position: absolute;
                top: -50%;
                right: -50%;
                width: 100%;
                height: 100%;
                background: rgba(255, 255, 255, 0.1);
                border-radius: 50%;
                transition: all 0.6s ease;
                transform: scale(0);
            }

            .stat-card:hover::before {
                transform: scale(2);
            }

            .stat-card.card-red {
                background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
            }

            .stat-card.card-blue {
                background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
            }

            .stat-card.card-yellow {
                background: linear-gradient(135deg, #f39c12 0%, #d68910 100%);
            }

            .stat-card.card-green {
                background: linear-gradient(135deg, #27ae60 0%, #229954 100%);
            }

            /* Animated Counter */
            .counter {
                font-size: 2.8rem;
                font-weight: 700;
                opacity: 0;
                animation: countUp 1.5s ease-out 0.5s forwards;
            }

            /* Enhanced Table Styles */
            .table-card {
                border-radius: 15px;
                overflow: hidden;
                background: white;
            }

            .table {
                margin-bottom: 0;
            }

            .table thead th {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                border: none;
                font-weight: 600;
                padding: 1rem;
            }

            .table tbody tr {
                transition: all 0.3s ease;
            }

            .table tbody tr:hover {
                background-color: rgba(102, 126, 234, 0.1);
                transform: scale(1.01);
            }

            /* Status Indicators */
            .status-indicator {
                width: 12px;
                height: 12px;
                border-radius: 50%;
                display: inline-block;
                animation: pulse 2s infinite;
            }

            .status-online {
                background: var(--success-color);
                box-shadow: 0 0 0 0 rgba(39, 174, 96, 1);
            }

            .status-warning {
                background: var(--warning-color);
                box-shadow: 0 0 0 0 rgba(243, 156, 18, 1);
            }

            .status-offline {
                background: var(--danger-color);
                box-shadow: 0 0 0 0 rgba(231, 76, 60, 1);
            }

            /* Enhanced Surveillance Cards */
            .surveillance-card {
                background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
                color: white;
                border-radius: 15px;
                position: relative;
                overflow: hidden;
            }

            .surveillance-feed {
                background: rgba(0, 0, 0, 0.3);
                border-radius: 10px;
                position: relative;
                overflow: hidden;
            }

            .surveillance-feed::after {
                content: '';
                position: absolute;
                top: 0;
                left: -100%;
                width: 100%;
                height: 100%;
                background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
                animation: scan 3s infinite;
            }

            /* Progress Bars */
            .progress {
                height: 6px;
                border-radius: 3px;
                overflow: hidden;
            }

            .progress-bar {
                background: linear-gradient(45deg, #667eea, #764ba2);
                transition: width 1.5s ease-in-out;
                animation: progressFill 2s ease-in-out;
            }

            /* Badges */
            .badge {
                padding: 0.5rem 1rem;
                border-radius: 20px;
                font-weight: 500;
                text-transform: uppercase;
                font-size: 0.75rem;
                letter-spacing: 0.5px;
            }

            /* Loading Animation for Charts */
            .chart-container {
                position: relative;
            }

            .chart-loading {
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                font-size: 1.2rem;
                color: var(--text-light);
            }

            /* Security Alert Styles */
            .security-alert {
                background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
                color: white;
                border-left: 4px solid #fff;
                animation: alertPulse 2s infinite;
            }

            /* Animations */
            @keyframes fadeInUp {
                from {
                    opacity: 0;
                    transform: translate3d(0, 40px, 0);
                }
                to {
                    opacity: 1;
                    transform: none;
                }
            }

            @keyframes slideInDown {
                from {
                    opacity: 0;
                    transform: translate3d(0, -40px, 0);
                }
                to {
                    opacity: 1;
                    transform: none;
                }
            }

            @keyframes countUp {
                from {
                    opacity: 0;
                    transform: translateY(20px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            @keyframes pulse {
                0% {
                    transform: scale(0.95);
                    box-shadow: 0 0 0 0 rgba(39, 174, 96, 0.7);
                }
                70% {
                    transform: scale(1);
                    box-shadow: 0 0 0 10px rgba(39, 174, 96, 0);
                }
                100% {
                    transform: scale(0.95);
                    box-shadow: 0 0 0 0 rgba(39, 174, 96, 0);
                }
            }

            @keyframes scan {
                0% { left: -100%; }
                100% { left: 100%; }
            }

            @keyframes progressFill {
                from { width: 0%; }
            }

            @keyframes alertPulse {
                0%, 100% { opacity: 1; }
                50% { opacity: 0.8; }
            }

            /* Responsive Design */
            @media (max-width: 768px) {
                .counter {
                    font-size: 2rem;
                }
                .card {
                    margin-bottom: 1rem;
                }
            }

            /* Dark Mode Support */
            @media (prefers-color-scheme: dark) {
                :root {
                    --card-bg: #2c3e50;
                    --text-dark: #ecf0f1;
                }
            }
        </style>
    @endpush

<div class="container-fluid">
    <!-- Enhanced Header -->
    <div class="page-header text-center">
        <div class="row align-items-center">
            <div class="col-12">
                <h1 class="mb-0">
                    <i class="fas fa-shield-alt me-3"></i>
                    {{ __('Security Command Center') }}
                </h1>
                <p class="lead mt-2 mb-0">{{ __('Real-time monitoring and incident management') }}</p>
            </div>
        </div>
    </div>

    <!-- Enhanced Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card card-red">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-8">
                            <h4 class="counter mb-0" data-count="{{ $totalIncidents }}">0</h4>
                            <p class="mb-0 text-white-50">{{ __('Total Incidents') }}</p>
                            <small class="text-white-50">
                                <i class="fas fa-arrow-up"></i> +12% from last month
                            </small>
                        </div>
                        <div class="col-4 text-end">
                            <div class="icon-container">
                                <i class="fas fa-exclamation-triangle fa-2x"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card card-blue">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-8">
                            <h4 class="counter mb-0" data-count="{{ $thisYearIncidents }}">0</h4>
                            <p class="mb-0 text-white-50">{{ __('This Year') }}</p>
                            <small class="text-white-50">
                                <i class="fas fa-arrow-down"></i> -8% from last year
                            </small>
                        </div>
                        <div class="col-4 text-end">
                            <i class="fas fa-calendar-alt fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card card-yellow">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-8">
                            <h4 class="counter mb-0" data-count="{{ $totalDeaths }}">0</h4>
                            <p class="mb-0 text-white-50">{{ __('Total Deaths') }}</p>
                            <small class="text-white-50">
                                <span class="status-indicator status-warning me-1"></span>
                                Critical
                            </small>
                        </div>
                        <div class="col-4 text-end">
                            <i class="fas fa-skull fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card stat-card card-green">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-8">
                            <h4 class="counter mb-0" data-count="{{ $totalInjured }}">0</h4>
                            <p class="mb-0 text-white-50">{{ __('Total Injured') }}</p>
                            <small class="text-white-50">
                                <span class="status-indicator status-online me-1"></span>
                                Monitored
                            </small>
                        </div>
                        <div class="col-4 text-end">
                            <i class="fas fa-plus-circle fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Analytics Row -->
    <div class="row mb-4">
        <!-- Incident Analysis -->
        <div class="col-lg-4 mb-4">
            <div class="card h-100">
                <div class="card-header bg-gradient text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-chart-line me-2"></i>
                        {{ __('Incident Analysis') }}
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-12">
                            <h6>{{ __('Monthly Trend') }}</h6>
                            <div class="chart-container" style="height: 200px;">
                                <canvas id="incidentTrendChart"></canvas>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <h6>{{ __('Top Categories') }}</h6>
                            <div class="category-list">
                                @foreach($categoriesData->take(5) as $index => $category)
                                <div class="category-item mb-3" style="animation-delay: {{ $index * 0.1 }}s">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <span class="fw-medium">{{ $category->incident_category }}</span>
                                        <span class="badge bg-primary">{{ $category->count }}</span>
                                    </div>
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" 
                                             style="width: {{ ($category->count / $categoriesData->max('count')) * 100 }}%"
                                             data-width="{{ ($category->count / $categoriesData->max('count')) * 100 }}"></div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Geographic Distribution -->
        <div class="col-lg-4 mb-4">
            <div class="card h-100">
                <div class="card-header bg-gradient text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-globe me-2"></i>
                        {{ __('Geographic Distribution') }}
                    </h5>
                </div>
                <div class="card-body">
                    <div class="text-center mb-3">
                        <div style="height: 250px;">
                            <canvas id="regionChart"></canvas>
                        </div>
                    </div>
                    <div>
                        <h6>{{ __('Top Regions') }}</h6>
                        @foreach($regionData->take(5) as $region)
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <div>
                                <span class="fw-medium">{{ $region->region }}</span>
                                <div class="progress mt-1" style="height: 4px;">
                                    <div class="progress-bar bg-info" 
                                         style="width: {{ ($region->count / $regionData->max('count')) * 100 }}%"></div>
                                </div>
                            </div>
                            <span class="badge bg-info ms-2">{{ $region->count }}</span>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <!-- Monthly Trends -->
        <div class="col-lg-4 mb-4">
            <div class="card h-100 surveillance-card">
                <div class="card-header border-0">
                    <h5 class="text-white mb-0">
                        <i class="fas fa-chart-area me-2"></i>
                        {{ __('Monthly Trends') }}
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row text-center mb-3">
                        <div class="col-4">
                            <div class="text-white">
                                <h6 class="mb-1">{{ __('Avg/Month') }}</h6>
                                <h4 class="counter" data-count="{{ round($thisYearIncidents / 12, 1) }}">0</h4>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="text-white">
                                <h6 class="mb-1">{{ __('Peak Month') }}</h6>
                                <h6>{{ collect($monthlyData)->sortByDesc('count')->first()['month'] ?? 'N/A' }}</h6>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="text-white">
                                <h6 class="mb-1">{{ __('Status') }}</h6>
                                <span class="status-indicator status-online"></span>
                            </div>
                        </div>
                    </div>
                    <div style="height: 200px;">
                        <canvas id="monthlyTrendChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Surveillance Row -->
    <div class="row mb-4">
        <!-- Camera Surveillance -->
        <div class="col-lg-4 mb-4">
            <div class="card surveillance-card h-100">
                <div class="card-header border-0 d-flex justify-content-between align-items-center">
                    <h5 class="text-white mb-0">
                        <i class="fas fa-video me-2"></i>
                        {{ __('Camera Surveillance') }}
                    </h5>
                    <span class="badge bg-success">
                        <span class="status-indicator status-online me-1"></span>
                        {{ __('Online') }}
                    </span>
                </div>
                <div class="card-body">
                    <div class="surveillance-feed text-center p-4 mb-3" style="height: 180px;">
                        <i class="fas fa-video fa-3x text-light mb-3"></i>
                        <p class="text-light">{{ __('Live Camera Feed') }}</p>
                        <small class="text-light">{{ __('Camera 1 - Downtown') }}</small>
                    </div>
                    <div class="row text-center">
                        <div class="col-4">
                            <div class="text-white">
                                <small>{{ __('Motion') }}</small>
                                <div class="h5">87%</div>
                                <div class="status-indicator status-online mx-auto"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="text-white">
                                <small>{{ __('Events') }}</small>
                                <div class="h5">23</div>
                                <div class="status-indicator status-warning mx-auto"></div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="text-white">
                                <small>{{ __('Status') }}</small>
                                <div class="h5">100%</div>
                                <div class="status-indicator status-online mx-auto"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Satellite Data -->
        <div class="col-lg-4 mb-4">
            <div class="card surveillance-card h-100">
                <div class="card-header border-0">
                    <h5 class="text-white mb-0">
                        <i class="fas fa-satellite me-2"></i>
                        {{ __('Satellite Data') }}
                    </h5>
                </div>
                <div class="card-body">
                    <div class="surveillance-feed text-center p-4 mb-3" style="height: 180px;">
                        <i class="fas fa-satellite fa-3x text-light mb-3"></i>
                        <p class="text-light">{{ __('Satellite Imagery') }}</p>
                        <small class="text-light">{{ __('Last Updated: 2 hours ago') }}</small>
                    </div>
                    <div>
                        <h6 class="text-white mb-2">{{ __('Coverage Analytics') }}</h6>
                        <div style="height: 120px;">
                            <canvas id="satelliteChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Drone Surveillance -->
        <div class="col-lg-4 mb-4">
            <div class="card surveillance-card h-100">
                <div class="card-header border-0 d-flex justify-content-between align-items-center">
                    <h5 class="text-white mb-0">
                        <i class="fas fa-helicopter me-2"></i>
                        {{ __('Drone Surveillance') }}
                    </h5>
                    <span class="badge bg-warning">{{ __('3 Active') }}</span>
                </div>
                <div class="card-body">
                    <div class="surveillance-feed text-center p-4 mb-3" style="height: 180px;">
                        <i class="fas fa-helicopter fa-3x text-light mb-3"></i>
                        <p class="text-light">{{ __('Drone Fleet Status') }}</p>
                        <small class="text-light">{{ __('Patrol Route Alpha') }}</small>
                    </div>
                    <div>
                        <h6 class="text-white mb-2">{{ __('Flight Analytics') }}</h6>
                        <div style="height: 120px;">
                            <canvas id="droneChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Tables Row -->
    <div class="row">
        <!-- Recent Incidents -->
        <div class="col-lg-8 mb-4">
            <div class="card table-card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 text-white">
                        <i class="fas fa-list me-2"></i>
                        {{ __('Recent Incidents') }}
                    </h5>
                    <a href="#" class="btn btn-light btn-sm">
                        <i class="fas fa-external-link-alt me-1"></i>
                        {{ __('View All') }}
                    </a>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>{{ __('Date') }}</th>
                                    <th>{{ __('Location') }}</th>
                                    <th>{{ __('Category') }}</th>
                                    <th>{{ __('Casualties') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($recentIncidents as $incident)
                                <tr>
                                    <td>
                                        <div class="fw-medium">{{ $incident->formatted_date }}</div>
                                    </td>
                                    <td>
                                        <div>
                                            <div class="fw-medium">{{ $incident->city_town ?? 'N/A' }}</div>
                                            <small class="text-muted">{{ $incident->state }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $incident->deaths > 5 ? 'danger' : ($incident->deaths > 0 ? 'warning' : 'info') }}">
                                            {{ $incident->incident_category }}
                                        </span>
                                    </td>
                                    <td>
                                        <div>
                                            <small><i class="fas fa-skull text-danger me-1"></i>{{ $incident->deaths }}</small><br>
                                            <small><i class="fas fa-plus text-warning me-1"></i>{{ $incident->injured }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="status-indicator status-{{ $incident->deaths > 5 ? 'offline' : ($incident->deaths > 0 ? 'warning' : 'online') }}"></span>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye me-1"></i>{{ __('View') }}
                                        </button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center py-4">
                                        <i class="fas fa-info-circle text-muted me-2"></i>
                                        {{ __('No recent incidents found') }}
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Most Affected Locations -->
        <div class="col-lg-4 mb-4">
            <div class="card h-100">
                <div class="card-header bg-gradient text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-map-marker-alt me-2"></i>
                        {{ __('Most Affected Locations') }}
                    </h5>
                </div>
                <div class="card-body">
                    @foreach($topLocations as $location)
                    <div class="location-item mb-4 p-3 border rounded" style="background: rgba(102, 126, 234, 0.05);">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <div>
                                <h6 class="mb-0 fw-bold">{{ $location->city_town }}</h6>
                                <small class="text-muted">{{ $location->state }}</small>
                            </div>
                            <span class="badge bg-danger fs-6">{{ $location->incident_count }}</span>
                        </div>
                        <div class="row text-center mb-2">
                            <div class="col-6">
                                <small class="text-danger">
                                    <i class="fas fa-skull me-1"></i>{{ $location->total_deaths }}
                                </small>
                            </div>
                            <div class="col-6">
                                <small class="text-warning">
                                    <i class="fas fa-plus me-1"></i>{{ $location->total_injured }}
                                </small>
                            </div>
                        </div>
                        <div class="progress" style="height: 6px;">
                            <div class="progress-bar bg-danger" 
                                 style="width: {{ ($location->incident_count / $topLocations->max('incident_count')) * 100 }}%"></div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Enhanced JavaScript -->
@push('script')
    <script src="{{ asset('plugins/owl.carousel/dist/owl.carousel.min.js') }}"></script>
    <script src="{{ asset('plugins/chartist/dist/chartist.min.js') }}"></script>
    <script src="{{ asset('plugins/flot-charts/jquery.flot.js') }}"></script>
  
        <!-- <script src="{{ asset('plugins/flot-charts/jquery.flot.categories.js') }}"></script> -->
        <script src="{{ asset('plugins/flot-charts/curvedLines.js') }}"></script>
        <script src="{{ asset('plugins/flot-charts/jquery.flot.tooltip.min.js') }}"></script>

        <script src="{{ asset('plugins/amcharts/amcharts.js') }}"></script>
        <script src="{{ asset('plugins/amcharts/serial.js') }}"></script>
        <script src="{{ asset('plugins/amcharts/themes/light.js') }}"></script>
       
        
        <script src="{{ asset('js/widget-statistic.js') }}"></script>
        <script src="{{ asset('js/widget-data.js') }}"></script>
        <script src="{{ asset('js/dashboard-charts.js') }}"></script>
        
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Monthly Trend Chart
const monthlyTrendCtx = document.getElementById('monthlyTrendChart');
if (monthlyTrendCtx) {
    new Chart(monthlyTrendCtx, {
        type: 'line',
        data: {
            labels: {!! json_encode(collect($monthlyData)->pluck('month')) !!},
            datasets: [{
                label: 'Incidents',
                data: {!! json_encode(collect($monthlyData)->pluck('count')) !!},
                borderColor: 'rgba(255, 255, 255, 0.8)',
                backgroundColor: 'rgba(255, 255, 255, 0.1)',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: { 
                    beginAtZero: true,
                    ticks: { color: 'rgba(255, 255, 255, 0.7)' },
                    grid: { color: 'rgba(255, 255, 255, 0.1)' }
                },
                x: { 
                    ticks: { color: 'rgba(255, 255, 255, 0.7)' },
                    grid: { color: 'rgba(255, 255, 255, 0.1)' }
                }
            }
        }
    });
}

// Category Pie Chart
const categoryPieCtx = document.getElementById('categoryPieChart');
if (categoryPieCtx) {
    new Chart(categoryPieCtx, {
        type: 'doughnut',
        data: {
            labels: {!! json_encode($categoriesData->take(5)->pluck('incident_category')) !!},
            datasets: [{
                data: {!! json_encode($categoriesData->take(5)->pluck('count')) !!},
                backgroundColor: [
                    '#FF6384', '#36A2EB', '#FFCE56', '#4BC0C0', '#9966FF'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { display: false }
            }
        }
    });
}

// Incident Trend Chart
const incidentTrendCtx = document.getElementById('incidentTrendChart');
if (incidentTrendCtx) {
    new Chart(incidentTrendCtx, {
        type: 'line',
        data: {
            labels: {!! json_encode(collect($monthlyData)->pluck('month')) !!},
            datasets: [{
                data: {!! json_encode(collect($monthlyData)->pluck('count')) !!},
                borderColor: '#36A2EB',
                backgroundColor: 'rgba(54, 162, 235, 0.1)',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: { legend: { display: false } },
            scales: {
                y: { display: false },
                x: { display: false }
            }
        }
    });
}

// Placeholder charts for surveillance components
const createPlaceholderChart = (canvasId, type = 'line') => {
    const ctx = document.getElementById(canvasId);
    if (ctx) {
        new Chart(ctx, {
            type: type,
            data: {
                labels: ['1', '2', '3', '4', '5'],
                datasets: [{
                    data: [12, 19, 3, 5, 2],
                    borderColor: '#36A2EB',
                    backgroundColor: 'rgba(54, 162, 235, 0.1)'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false } },
                scales: {
                    y: { display: false },
                    x: { display: false }
                }
            }
        });
    }
};

// Create placeholder charts
createPlaceholderChart('motionChart');
createPlaceholderChart('satelliteChart');
createPlaceholderChart('droneChart');
createPlaceholderChart('regionChart', 'doughnut');
</script>

    @endpush
