 
<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('content'); ?>
    <!-- push external head elements to head -->
    <?php $__env->startPush('head'); ?>

        <link rel="stylesheet" href="<?php echo e(asset('plugins/weather-icons/css/weather-icons.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('plugins/owl.carousel/dist/assets/owl.carousel.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('plugins/owl.carousel/dist/assets/owl.theme.default.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('plugins/chartist/dist/chartist.min.css')); ?>">
    <?php $__env->stopPush(); ?>


<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- <div class="row">
        <div class="col-12">
            <h1 class="page-header"><?php echo e(__('Command Control Center')); ?></h1>
        </div>
    </div> -->
    

    <div class="row">
        <!-- Incident Statistics Cards -->
        <div class="col-xl-3 col-md-6">
            <div class="card card-red text-white">
                <div class="card-block">
                    <div class="row align-items-center">
                        <div class="col-8">
                            <h4 class="mb-0"><?php echo e(number_format($totalIncidents)); ?></h4>
                            <p class="mb-0"><?php echo e(__('Total Incidents')); ?></p>
                        </div>
                        <div class="col-4 text-right">
                            <i class="fas fa-exclamation-triangle f-30"></i>
                        </div>
                    </div>
                    <!-- <div id="incident-trend-chart" class="chart-line chart-shadow"></div> -->
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card card-blue text-white">
                <div class="card-block">
                    <div class="row align-items-center">
                        <div class="col-8">
                            <h4 class="mb-0"><?php echo e(number_format($thisYearIncidents)); ?></h4>
                            <p class="mb-0"><?php echo e(__('This Year')); ?></p>
                        </div>
                        <div class="col-4 text-right">
                            <i class="fas fa-calendar-alt f-30"></i>
                        </div>
                    </div>
                    <!-- <div id="yearly-trend-chart" class="chart-line chart-shadow"></div> -->
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card card-yellow text-white">
                <div class="card-block">
                    <div class="row align-items-center">
                        <div class="col-8">
                            <h4 class="mb-0"><?php echo e(number_format($totalDeaths)); ?></h4>
                            <p class="mb-0"><?php echo e(__('Total Deaths')); ?></p>
                        </div>
                        <div class="col-4 text-right">
                            <i class="fas fa-skull f-30"></i>
                        </div>
                    </div>
                    <!-- <div id="deaths-chart" class="chart-line chart-shadow"></div> -->
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card card-green text-white">
                <div class="card-block">
                    <div class="row align-items-center">
                        <div class="col-8">
                            <h4 class="mb-0"><?php echo e(number_format($totalInjured)); ?></h4>
                            <p class="mb-0"><?php echo e(__('Total Injured')); ?></p>
                        </div>
                        <div class="col-4 text-right">
                            <i class="fas fa-plus-circle f-30"></i>
                        </div>
                    </div>
                    <!-- <div id="injured-chart" class="chart-line chart-shadow"></div> -->
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Incident Analysis -->
        <div class="col-md-6 col-xl-4">
            <div class="card">
                <div class="card-header">
                    <h3><?php echo e(__('Incident Analysis')); ?></h3>
                </div>
                <div class="card-block">
                    <div class="row mb-3">
                        <div class="col-6">
                            <h6><?php echo e(__('Trend')); ?></h6>
                         <div style="height: 250px;">    <canvas id="incidentTrendChart" ></canvas></div>
                        </div>
                        <div class="col-6">
                            <h6><?php echo e(__('Category Distribution')); ?></h6>
                           <div style="height: 250px;">  <canvas id="categoryPieChart" ></canvas></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <h6><?php echo e(__('Incident Categories')); ?></h6>
                            <div class="incident-categories">
                                <?php $__currentLoopData = $categoriesData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="category-item mb-2">
                                    <div class="d-flex justify-content-between">
                                        <span><?php echo e($category->incident_category); ?></span>
                                        <span class="badge badge-primary"><?php echo e($category->count); ?></span>
                                    </div>
                                    <div class="progress" style="height: 4px;">
                                        <div class="progress-bar" role="progressbar" 
                                             style="width: <?php echo e(($category->count / $categoriesData->max('count')) * 100); ?>%"></div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Geographic Distribution -->
        <div class="col-md-6 col-xl-4">
            <div class="card">
                <div class="card-header">
                    <h3><?php echo e(__('Geographic Distribution')); ?></h3>
                </div>
                <div class="card-block">
                    <div class="row mb-3">
                        <div class="col-6">
                           <div style="height: 250px;">  <canvas id="regionChart" ></canvas></div>
                        </div>
                        <div class="col-6">
                            <h6><?php echo e(__('Top Regions')); ?></h6>
                            <?php $__currentLoopData = $regionData->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex justify-content-between mb-1">
                                <small><?php echo e($region->region); ?></small>
                                <small class="text-muted"><?php echo e($region->count); ?></small>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Monthly Trends -->
        <div class="col-md-12 col-xl-4">
            <div class="card card-blue text-white">
                <div class="card-block pb-0">
                    <div class="row mb-3">
                        <div class="col">
                            <h6 class="mb-2"><?php echo e(__('Monthly Analysis')); ?></h6>
                            <h5 class="mb-0 fw-700"><?php echo e(__('Current Year')); ?></h5>
                        </div>
                        <div class="col-auto text-center">
                            <p class="mb-2"><?php echo e(__('Avg/Month')); ?></p>
                            <h6 class="mb-0"><?php echo e(number_format($thisYearIncidents / 12, 1)); ?></h6>
                        </div>
                        <div class="col-auto text-center">
                            <p class="mb-2"><?php echo e(__('Peak Month')); ?></p>
                            <h6 class="mb-0"><?php echo e(collect($monthlyData)->sortByDesc('count')->first()['month'] ?? 'N/A'); ?></h6>
                        </div>
                    </div>
                    <div style="height: 250px;"> <canvas id="monthlyTrendChart"></canvas></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Camera Surveillance (Placeholder) -->
        <div class="col-md-6 col-xl-4">
            <div class="card">
                <div class="card-header">
                    <h3><?php echo e(__('Camera Surveillance')); ?></h3>
                    <div class="card-header-right">
                        <span class="badge badge-success"><?php echo e(__('Online')); ?></span>
                    </div>
                </div>
                <div class="card-block">
                    <div class="surveillance-feed">
                        <div class="camera-view bg-light p-4 text-center" style="height: 200px;">
                            <i class="fas fa-video fa-3x text-muted mb-3"></i>
                            <p class="text-muted"><?php echo e(__('Live Camera Feed')); ?></p>
                            <small class="text-muted"><?php echo e(__('Camera 1 - Downtown')); ?></small>
                        </div>
                        <!-- <div class="row mt-3">
                            <div class="col-4">
                                <div class="text-center">
                                    <h6 class="mb-0"><?php echo e(__('Motion')); ?></h6>
                                    <canvas id="motionChart" width="50" height="30"></canvas>
                                    <small class="text-muted">10%</small>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="text-center">
                                    <h6 class="mb-0"><?php echo e(__('Events')); ?></h6>
                                    <div class="event-indicator bg-success" style="width: 30px; height: 30px; border-radius: 50%; margin: 0 auto;"></div>
                                    <small class="text-muted"><?php echo e(__('10%')); ?></small>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="text-center">
                                    <h6 class="mb-0"><?php echo e(__('Status')); ?></h6>
                                    <div class="status-indicator bg-success" style="width: 30px; height: 30px; border-radius: 50%; margin: 0 auto;"></div>
                                    <small class="text-muted"><?php echo e(__('100%')); ?></small>
                                </div>
                            </div>
                        </div> -->
                    </div>
                </div>
            </div>
        </div>

        <!-- Satellite Data (Placeholder) -->
        <div class="col-md-6 col-xl-4">
            <div class="card">
                <div class="card-header">
                    <h3><?php echo e(__('Satellite Data')); ?></h3>
                </div>
                <div class="card-block">
                    <div class="satellite-view bg-light p-4 text-center" style="height: 200px;">
                        <i class="fas fa-satellite fa-3x text-muted mb-3"></i>
                        <p class="text-muted"><?php echo e(__('Satellite Imagery')); ?></p>
                        <small class="text-muted"><?php echo e(__('Last Updated: 2 hours ago')); ?></small>
                    </div>
                    <div class="mt-3">
                        <h6><?php echo e(__('Analytics')); ?></h6>
                        <div style="height: 250px;"> <canvas id="satelliteChart" ></canvas></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Drone Surveillance (Placeholder) -->
        <div class="col-md-12 col-xl-4">
            <div class="card">
                <div class="card-header">
                    <h3><?php echo e(__('Drone Surveillance')); ?></h3>
                    <div class="card-header-right">
                        <span class="badge badge-warning"><?php echo e(__('3 Active')); ?></span>
                    </div>
                </div>
                <div class="card-block">
                    <div class="drone-view bg-light p-4 text-center" style="height: 200px;">
                        <i class="fas fa-helicopter fa-3x text-muted mb-3"></i>
                        <p class="text-muted"><?php echo e(__('Drone Feed')); ?></p>
                        <small class="text-muted"><?php echo e(__('Patrol Route Alpha')); ?></small>
                    </div>
                    <div class="mt-3">
                        <h6><?php echo e(__('Analytics')); ?></h6>
                        <div style="height: 250px;"> <canvas id="droneChart" ></canvas></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Recent Incidents -->
        <div class="col-xl-8 col-md-12">
            <div class="card table-card">
                <div class="card-header">
                    <h3><?php echo e(__('Recent Incidents')); ?></h3>
                    <div class="card-header-right">
                        <a href="#" class="btn btn-sm btn-primary"><?php echo e(__('View All')); ?></a>
                    </div>
                </div>
                <div class="card-block">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Date')); ?></th>
                                    <th><?php echo e(__('Location')); ?></th>
                                    <th><?php echo e(__('Category')); ?></th>
                                    <th><?php echo e(__('Casualties')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $recentIncidents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $incident): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($incident->formatted_date); ?></td>
                                    <td>
                                        <div>
                                            <strong><?php echo e($incident->city_town ?? 'N/A'); ?></strong><br>
                                            <small class="text-muted"><?php echo e($incident->state); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?php echo e($incident->deaths > 5 ? 'danger' : ($incident->deaths > 0 ? 'warning' : 'info')); ?>">
                                            <?php echo e($incident->incident_category); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div>
                                            <small>Deaths: <?php echo e($incident->deaths); ?></small><br>
                                            <small>Injured: <?php echo e($incident->injured); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="p-status bg-<?php echo e($incident->deaths > 5 ? 'red' : ($incident->deaths > 0 ? 'yellow' : 'green')); ?>"></div>
                                    </td>
                                    <td>
                                        <a href="#" class="btn btn-sm btn-outline-primary"><?php echo e(__('View')); ?></a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center"><?php echo e(__('No recent incidents found')); ?></td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Affected Locations -->
        <div class="col-xl-4 col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3><?php echo e(__('Most Affected Locations')); ?></h3>
                </div>
                <div class="card-block">
                    <?php $__currentLoopData = $topLocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="location-item mb-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-0"><?php echo e($location->city_town); ?></h6>
                                <small class="text-muted"><?php echo e($location->state); ?></small>
                            </div>
                            <div class="text-right">
                                <span class="badge badge-danger"><?php echo e($location->incident_count); ?></span>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-6">
                                <small class="text-muted">Deaths: <?php echo e($location->total_deaths); ?></small>
                            </div>
                            <div class="col-6">
                                <small class="text-muted">Injured: <?php echo e($location->total_injured); ?></small>
                            </div>
                        </div>
                        <div class="progress mt-2" style="height: 3px;">
                            <div class="progress-bar bg-danger" role="progressbar" 
                                 style="width: <?php echo e(($location->incident_count / $topLocations->max('incident_count')) * 100); ?>%"></div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

	<!-- push external js -->
    <?php $__env->startPush('script'); ?>
        <script src="<?php echo e(asset('plugins/owl.carousel/dist/owl.carousel.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/chartist/dist/chartist.min.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/flot-charts/jquery.flot.js')); ?>"></script>
        <!-- <script src="<?php echo e(asset('plugins/flot-charts/jquery.flot.categories.js')); ?>"></script> -->
        <script src="<?php echo e(asset('plugins/flot-charts/curvedLines.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/flot-charts/jquery.flot.tooltip.min.js')); ?>"></script>

        <script src="<?php echo e(asset('plugins/amcharts/amcharts.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/amcharts/serial.js')); ?>"></script>
        <script src="<?php echo e(asset('plugins/amcharts/themes/light.js')); ?>"></script>
       
        
        <script src="<?php echo e(asset('js/widget-statistic.js')); ?>"></script>
        <script src="<?php echo e(asset('js/widget-data.js')); ?>"></script>
        <script src="<?php echo e(asset('js/dashboard-charts.js')); ?>"></script>
        
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Monthly Trend Chart
const monthlyTrendCtx = document.getElementById('monthlyTrendChart');
if (monthlyTrendCtx) {
    new Chart(monthlyTrendCtx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode(collect($monthlyData)->pluck('month')); ?>,
            datasets: [{
                label: 'Incidents',
                data: <?php echo json_encode(collect($monthlyData)->pluck('count')); ?>,
                borderColor: 'rgba(255, 255, 255, 0.8)',
                backgroundColor: 'rgba(255, 255, 255, 0.1)',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: { 
                    beginAtZero: true,
                    ticks: { color: 'rgba(255, 255, 255, 0.7)' },
                    grid: { color: 'rgba(255, 255, 255, 0.1)' }
                },
                x: { 
                    ticks: { color: 'rgba(255, 255, 255, 0.7)' },
                    grid: { color: 'rgba(255, 255, 255, 0.1)' }
                }
            }
        }
    });
}

// Category Pie Chart
const categoryPieCtx = document.getElementById('categoryPieChart');
if (categoryPieCtx) {
    new Chart(categoryPieCtx, {
        type: 'doughnut',
        data: {
            labels: <?php echo json_encode($categoriesData->take(5)->pluck('incident_category')); ?>,
            datasets: [{
                data: <?php echo json_encode($categoriesData->take(5)->pluck('count')); ?>,
                backgroundColor: [
                    '#FF6384', '#36A2EB', '#FFCE56', '#4BC0C0', '#9966FF'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { display: false }
            }
        }
    });
}

// Incident Trend Chart
const incidentTrendCtx = document.getElementById('incidentTrendChart');
if (incidentTrendCtx) {
    new Chart(incidentTrendCtx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode(collect($monthlyData)->pluck('month')); ?>,
            datasets: [{
                data: <?php echo json_encode(collect($monthlyData)->pluck('count')); ?>,
                borderColor: '#36A2EB',
                backgroundColor: 'rgba(54, 162, 235, 0.1)',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: { legend: { display: false } },
            scales: {
                y: { display: false },
                x: { display: false }
            }
        }
    });
}

// Placeholder charts for surveillance components
const createPlaceholderChart = (canvasId, type = 'line') => {
    const ctx = document.getElementById(canvasId);
    if (ctx) {
        new Chart(ctx, {
            type: type,
            data: {
                labels: ['1', '2', '3', '4', '5'],
                datasets: [{
                    data: [12, 19, 3, 5, 2],
                    borderColor: '#36A2EB',
                    backgroundColor: 'rgba(54, 162, 235, 0.1)'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false } },
                scales: {
                    y: { display: false },
                    x: { display: false }
                }
            }
        });
    }
};

// Create placeholder charts
createPlaceholderChart('motionChart');
createPlaceholderChart('satelliteChart');
createPlaceholderChart('droneChart');
createPlaceholderChart('regionChart', 'doughnut');
</script>

    <?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/montela/resources/views/pages/dashboard.blade.php ENDPATH**/ ?>