<!doctype html>
<html class="no-js" lang="en">
<head> 
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>ASAT - Advanced Security Analysis Tool</title>
    <meta name="description" content="Internal Security Operations Dashboard">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link rel="icon" href="favicon.png" type="image/x-icon" />
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;500;700;900&family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #0a0a0a;
            color: #ffffff;
            overflow: hidden;
            height: 100vh;
            position: relative;
        }

        /* Animated Background */
        .background-grid {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                linear-gradient(rgba(0, 255, 255, 0.03) 1px, transparent 1px),
                linear-gradient(90deg, rgba(0, 255, 255, 0.03) 1px, transparent 1px);
            background-size: 50px 50px;
            animation: grid-move 20s linear infinite;
            z-index: -2;
        }

        @keyframes grid-move {
            0% { transform: translate(0, 0); }
            100% { transform: translate(50px, 50px); }
        }

        .background-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(ellipse at center, rgba(0, 20, 40, 0.3) 0%, rgba(0, 0, 0, 0.8) 100%);
            z-index: -1;
        }

        /* Header */
        .header {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            padding: 20px 40px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: rgba(0, 0, 0, 0.3);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(0, 255, 255, 0.2);
            z-index: 1000;
        }

        .logo {
            font-family: 'Orbitron', monospace;
            font-size: 28px;
            font-weight: 700;
            color: #00ffff;
            text-shadow: 0 0 20px rgba(0, 255, 255, 0.5);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .logo i {
            font-size: 32px;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }

        .system-status {
            display: flex;
            align-items: center;
            gap: 20px;
            font-family: 'Orbitron', monospace;
        }

        .status-indicator {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 16px;
            background: rgba(0, 255, 0, 0.1);
            border: 1px solid rgba(0, 255, 0, 0.3);
            border-radius: 20px;
            font-size: 12px;
        }

        .status-dot {
            width: 8px;
            height: 8px;
            background: #00ff00;
            border-radius: 50%;
            animation: blink 1.5s infinite;
        }

        @keyframes blink {
            0%, 50% { opacity: 1; }
            51%, 100% { opacity: 0.3; }
        }

        .login-btn {
            padding: 12px 30px;
            background: linear-gradient(45deg, #ff6b35, #ff8e35);
            border: none;
            border-radius: 25px;
            color: white;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
            font-family: 'Inter', sans-serif;
        }

        .login-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(255, 107, 53, 0.4);
        }

        /* Main Dashboard */
        .dashboard {
            padding: 120px 40px 40px;
            height: 100vh;
            display: grid;
            grid-template-columns: 1fr 1fr;
            grid-template-rows: auto 1fr 1fr;
            gap: 30px;
            max-width: 1600px;
            margin: 0 auto;
        }

        /* Central Command Panel */
        .central-panel {
            grid-column: 1 / -1;
            background: rgba(0, 20, 40, 0.4);
            border: 1px solid rgba(0, 255, 255, 0.3);
            border-radius: 20px;
            padding: 30px;
            backdrop-filter: blur(15px);
            position: relative;
            overflow: hidden;
        }

        .central-panel::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(0, 255, 255, 0.1), transparent);
            animation: scan 3s infinite;
        }

        @keyframes scan {
            0% { left: -100%; }
            100% { left: 100%; }
        }

        .panel-title {
            font-family: 'Orbitron', monospace;
            font-size: 24px;
            color: #00ffff;
            text-align: center;
            margin-bottom: 20px;
            text-shadow: 0 0 10px rgba(0, 255, 255, 0.5);
        }

        .system-overview {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            text-align: center;
        }

        .metric-card {
            background: rgba(0, 0, 0, 0.3);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 15px;
            padding: 20px;
            transition: all 0.3s ease;
        }

        .metric-card:hover {
            border-color: rgba(0, 255, 255, 0.5);
            transform: translateY(-5px);
        }

        .metric-icon {
            font-size: 32px;
            margin-bottom: 10px;
        }

        .metric-card:nth-child(1) .metric-icon { color: #ff6b35; }
        .metric-card:nth-child(2) .metric-icon { color: #00ff00; }
        .metric-card:nth-child(3) .metric-icon { color: #ffff00; }
        .metric-card:nth-child(4) .metric-icon { color: #ff00ff; }

        .metric-value {
            font-family: 'Orbitron', monospace;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 5px;
        }

        .metric-label {
            font-size: 12px;
            opacity: 0.8;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        /* Side Panels */
        .data-panel {
            background: rgba(0, 20, 40, 0.4);
            border: 1px solid rgba(0, 255, 255, 0.3);
            border-radius: 20px;
            padding: 25px;
            backdrop-filter: blur(15px);
            display: flex;
            flex-direction: column;
        }

        .panel-header {
            font-family: 'Orbitron', monospace;
            font-size: 16px;
            color: #00ffff;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .activity-feed {
            flex: 1;
            overflow-y: auto;
        }

        .activity-item {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 12px;
            margin-bottom: 10px;
            background: rgba(0, 0, 0, 0.3);
            border-radius: 8px;
            border-left: 3px solid;
            font-size: 14px;
            opacity: 0;
            animation: slideIn 0.5s ease forwards;
        }

        .activity-item:nth-child(odd) { border-left-color: #00ff00; }
        .activity-item:nth-child(even) { border-left-color: #ffff00; }

        .activity-item:nth-child(1) { animation-delay: 0.1s; }
        .activity-item:nth-child(2) { animation-delay: 0.3s; }
        .activity-item:nth-child(3) { animation-delay: 0.5s; }
        .activity-item:nth-child(4) { animation-delay: 0.7s; }
        .activity-item:nth-child(5) { animation-delay: 0.9s; }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateX(-20px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        .activity-icon {
            width: 8px;
            height: 8px;
            background: currentColor;
            border-radius: 50%;
            flex-shrink: 0;
        }

        .activity-time {
            font-family: 'Orbitron', monospace;
            font-size: 11px;
            opacity: 0.6;
            margin-left: auto;
        }

        /* Charts */
        .chart-container {
            height: 200px;
            display: flex;
            align-items: end;
            justify-content: space-between;
            padding: 20px 0;
            gap: 5px;
        }

        .chart-bar {
            background: linear-gradient(to top, #ff6b35, #00ffff);
            border-radius: 3px 3px 0 0;
            width: 15px;
            animation: growUp 2s ease-in-out infinite alternate;
            opacity: 0.8;
        }

        .chart-bar:nth-child(odd) { animation-delay: 0.2s; }
        .chart-bar:nth-child(even) { animation-delay: 0.4s; }

        @keyframes growUp {
            from { height: 20%; }
            to { height: var(--height, 60%); }
        }

        /* Threat Map */
        .threat-map {
            position: relative;
            background: rgba(0, 0, 0, 0.5);
            border-radius: 10px;
            height: 200px;
            overflow: hidden;
        }

        .map-point {
            position: absolute;
            width: 12px;
            height: 12px;
            background: #ff0000;
            border-radius: 50%;
            animation: ping 2s infinite;
        }

        @keyframes ping {
            0% {
                transform: scale(1);
                opacity: 1;
            }
            75%, 100% {
                transform: scale(2);
                opacity: 0;
            }
        }

        .map-point:nth-child(1) { top: 20%; left: 15%; animation-delay: 0s; }
        .map-point:nth-child(2) { top: 60%; left: 30%; animation-delay: 0.5s; }
        .map-point:nth-child(3) { top: 40%; left: 70%; animation-delay: 1s; }
        .map-point:nth-child(4) { top: 80%; left: 85%; animation-delay: 1.5s; }

        /* Scrollbar Styling */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 3px;
        }

        ::-webkit-scrollbar-thumb {
            background: rgba(0, 255, 255, 0.5);
            border-radius: 3px;
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .dashboard {
                grid-template-columns: 1fr;
                grid-template-rows: auto auto auto;
                padding: 100px 20px 20px;
            }
            
            .system-overview {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 768px) {
            .header {
                padding: 15px 20px;
                flex-direction: column;
                gap: 15px;
            }
            
            .logo {
                font-size: 24px;
            }
            
            .system-overview {
                grid-template-columns: 1fr;
                gap: 15px;
            }
        }
    </style>
</head>

<body>
    <div class="background-grid"></div>
    <div class="background-overlay"></div>

    <!-- Header -->
    <header class="header">
        <div class="logo">
            <i class="fas fa-shield-alt"></i>
            ASAT
        </div>
        
        <div class="system-status">
            <div class="status-indicator">
                <div class="status-dot"></div>
                SYSTEM ONLINE
            </div>
            <div style="font-size: 14px; opacity: 0.7;" id="current-time"></div>
        </div>
        
        <a href="/login" class="login-btn">
            <i class="fas fa-sign-in-alt"></i> ACCESS SYSTEM
        </a>
    </header>

    <!-- Main Dashboard -->
    <main class="dashboard">
        <!-- Central Command Panel -->
        <section class="central-panel">
            <h2 class="panel-title">SECURITY OPERATIONS CENTER</h2>
            <div class="system-overview">
                <div class="metric-card">
                    <div class="metric-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <div class="metric-value" id="incidents-count">0</div>
                    <div class="metric-label">Active Incidents</div>
                </div>
                
                <div class="metric-card">
                    <div class="metric-icon">
                        <i class="fas fa-video"></i>
                    </div>
                    <div class="metric-value" id="cameras-count">0</div>
                    <div class="metric-label">Cameras Online</div>
                </div>
                
                <div class="metric-card">
                    <div class="metric-icon">
                        <i class="fas fa-satellite"></i>
                    </div>
                    <div class="metric-value" id="satellites-count">0</div>
                    <div class="metric-label">Satellites Active</div>
                </div>
                
                <div class="metric-card">
                    <div class="metric-icon">
                        <i class="fas fa-helicopter"></i>
                    </div>
                    <div class="metric-value" id="drones-count">0</div>
                    <div class="metric-label">Drones Deployed</div>
                </div>
            </div>
        </section>

        <!-- Real-time Activity Feed -->
        <section class="data-panel">
            <div class="panel-header">
                <i class="fas fa-stream"></i>
                REAL-TIME ACTIVITY
            </div>
            <div class="activity-feed" id="activity-feed">
                <div class="activity-item">
                    <div class="activity-icon"></div>
                    <span>Camera #23 motion detected - Sector 7</span>
                    <span class="activity-time">14:23:45</span>
                </div>
                <div class="activity-item">
                    <div class="activity-icon"></div>
                    <span>Satellite uplink established - SAT-04</span>
                    <span class="activity-time">14:22:12</span>
                </div>
                <div class="activity-item">
                    <div class="activity-icon"></div>
                    <span>Drone patrol completed - Zone Alpha</span>
                    <span class="activity-time">14:21:38</span>
                </div>
                <div class="activity-item">
                    <div class="activity-icon"></div>
                    <span>Perimeter breach alert cleared</span>
                    <span class="activity-time">14:20:54</span>
                </div>
                <div class="activity-item">
                    <div class="activity-icon"></div>
                    <span>System backup completed successfully</span>
                    <span class="activity-time">14:19:22</span>
                </div>
            </div>
        </section>

        <!-- Threat Analysis -->
        <section class="data-panel">
            <div class="panel-header">
                <i class="fas fa-chart-line"></i>
                THREAT ANALYSIS
            </div>
            <div class="chart-container">
                <div class="chart-bar" style="--height: 45%;"></div>
                <div class="chart-bar" style="--height: 65%;"></div>
                <div class="chart-bar" style="--height: 35%;"></div>
                <div class="chart-bar" style="--height: 80%;"></div>
                <div class="chart-bar" style="--height: 25%;"></div>
                <div class="chart-bar" style="--height: 55%;"></div>
                <div class="chart-bar" style="--height: 90%;"></div>
                <div class="chart-bar" style="--height: 40%;"></div>
                <div class="chart-bar" style="--height: 70%;"></div>
                <div class="chart-bar" style="--height: 30%;"></div>
                <div class="chart-bar" style="--height: 85%;"></div>
                <div class="chart-bar" style="--height: 50%;"></div>
            </div>
            <div class="threat-map">
                <div class="map-point"></div>
                <div class="map-point"></div>
                <div class="map-point"></div>
                <div class="map-point"></div>
            </div>
        </section>

        <!-- System Monitoring -->
        <section class="data-panel">
            <div class="panel-header">
                <i class="fas fa-server"></i>
                SYSTEM MONITORING
            </div>
            <div style="flex: 1;">
                <div style="margin-bottom: 20px;">
                    <div style="display: flex; justify-content: between; margin-bottom: 5px;">
                        <span>CPU Usage</span>
                        <span id="cpu-usage">0%</span>
                    </div>
                    <div style="background: rgba(255,255,255,0.1); height: 8px; border-radius: 4px; overflow: hidden;">
                        <div id="cpu-bar" style="height: 100%; background: linear-gradient(90deg, #00ff00, #ffff00, #ff0000); width: 0%; transition: width 1s ease;"></div>
                    </div>
                </div>
                
                <div style="margin-bottom: 20px;">
                    <div style="display: flex; justify-content: between; margin-bottom: 5px;">
                        <span>Memory Usage</span>
                        <span id="memory-usage">0%</span>
                    </div>
                    <div style="background: rgba(255,255,255,0.1); height: 8px; border-radius: 4px; overflow: hidden;">
                        <div id="memory-bar" style="height: 100%; background: linear-gradient(90deg, #00ff00, #ffff00, #ff0000); width: 0%; transition: width 1s ease;"></div>
                    </div>
                </div>
                
                <div style="margin-bottom: 20px;">
                    <div style="display: flex; justify-content: between; margin-bottom: 5px;">
                        <span>Network Activity</span>
                        <span id="network-usage">0%</span>
                    </div>
                    <div style="background: rgba(255,255,255,0.1); height: 8px; border-radius: 4px; overflow: hidden;">
                        <div id="network-bar" style="height: 100%; background: linear-gradient(90deg, #00ff00, #ffff00, #ff0000); width: 0%; transition: width 1s ease;"></div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <script>
        // Update current time
        function updateTime() {
            const now = new Date();
            document.getElementById('current-time').textContent = now.toLocaleTimeString();
        }
        setInterval(updateTime, 1000);
        updateTime();

        // Animate counters
        function animateCounter(elementId, target, duration = 2000) {
            const element = document.getElementById(elementId);
            const start = 0;
            const startTime = performance.now();
            
            function update(currentTime) {
                const elapsed = currentTime - startTime;
                const progress = Math.min(elapsed / duration, 1);
                const current = Math.floor(progress * target);
                element.textContent = current;
                
                if (progress < 1) {
                    requestAnimationFrame(update);
                }
            }
            requestAnimationFrame(update);
        }

        // Animate system metrics on page load
        window.addEventListener('load', () => {
            setTimeout(() => animateCounter('incidents-count', 3), 500);
            setTimeout(() => animateCounter('cameras-count', 47), 700);
            setTimeout(() => animateCounter('satellites-count', 8), 900);
            setTimeout(() => animateCounter('drones-count', 12), 1100);
        });

        // Real-time activity simulation
        const activities = [
            "Facial recognition match - Person ID: 4821",
            "Drone battery level critical - RTB initiated",
            "Satellite imagery updated - Grid 23-A",
            "Motion sensor triggered - Building C",
            "Network intrusion attempt blocked",
            "Temperature anomaly detected - Server room",
            "Access card used - Level 3 clearance",
            "Emergency protocol activated - Drill mode",
            "Communication link established - Unit 7",
            "Backup system status: OK"
        ];

        function addNewActivity() {
            const feed = document.getElementById('activity-feed');
            const activity = activities[Math.floor(Math.random() * activities.length)];
            const time = new Date().toLocaleTimeString();
            
            const item = document.createElement('div');
            item.className = 'activity-item';
            item.innerHTML = `
                <div class="activity-icon"></div>
                <span>${activity}</span>
                <span class="activity-time">${time}</span>
            `;
            
            feed.insertBefore(item, feed.firstChild);
            
            // Remove old items to keep list manageable
            if (feed.children.length > 10) {
                feed.removeChild(feed.lastChild);
            }
        }

        // Add new activity every 3-8 seconds
        setInterval(addNewActivity, Math.random() * 5000 + 3000);

        // Animate system monitoring bars
        function updateSystemMetrics() {
            const cpu = Math.random() * 100;
            const memory = Math.random() * 100;
            const network = Math.random() * 100;
            
            document.getElementById('cpu-usage').textContent = Math.floor(cpu) + '%';
            document.getElementById('memory-usage').textContent = Math.floor(memory) + '%';
            document.getElementById('network-usage').textContent = Math.floor(network) + '%';
            
            document.getElementById('cpu-bar').style.width = cpu + '%';
            document.getElementById('memory-bar').style.width = memory + '%';
            document.getElementById('network-bar').style.width = network + '%';
        }

        // Update metrics every 2 seconds
        setInterval(updateSystemMetrics, 2000);
        updateSystemMetrics();

        // Keyboard shortcut for login (Ctrl + L)
        document.addEventListener('keydown', (e) => {
            if (e.ctrlKey && e.key === 'l') {
                e.preventDefault();
                window.location.href = '/login';
            }
        });
    </script>
</body>
</html><?php /**PATH /home/bybluepa/public_html/asat.bybluepage.com/resources/views/home.blade.php ENDPATH**/ ?>