<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssetReport extends Model
{
    use HasFactory;

    protected $table = 'asset_reports';

    protected $fillable = [
        'local_id_report',
        'state',
        'lga',
        'ward',
        'specific_location',
        'latitude',
        'longitude',
        'asset_type',
        'asset_name',
        'asset_id',
        'situation_status',
        'condition',
        'completion_percentage',
        'damage_level',
        'description',
        'issues',
        'photo_uris',
        'user_id',
        'report_date',
        'active',
    ];

    protected $casts = [
        'report_date' => 'integer',
        'active' => 'integer',
    ];

    /**
     * Relationship with User
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}