@extends('layouts.main') 

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0"><i class="fas fa-building"></i> Asset Reports</h4>
                    <div>
                        <a href="{{ route('asset-reports.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Add New Report
                        </a>
                        <a href="{{ route('asset-reports.export') }}" class="btn btn-success">
                            <i class="fas fa-download"></i> Export CSV
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <!-- Filter Form -->
                    <form method="GET" action="{{ route('asset-reports.index') }}" class="mb-4">
                        <div class="row g-3">
                            <div class="col-md-3">
                                <select name="lga" class="form-select">
                                    <option value="">All LGAs</option>
                                    @foreach(['Bakori', 'Batagarawa', 'Batsari', 'Baure', 'Bindawa', 'Charanchi', 'Dandume', 'Danja', 'Dan Musa', 'Daura', 'Dutsi', 'Dutsin Ma', 'Faskari', 'Funtua', 'Ingawa', 'Jibia', 'Kafur', 'Kaita', 'Kankara', 'Kankia', 'Katsina', 'Kurfi', 'Kusada', "Mai'Adua", 'Malumfashi', 'Mani', 'Mashi', 'Matazu', 'Musawa', 'Rimi', 'Sabuwa', 'Safana', 'Sandamu', 'Zango'] as $lga)
                                        <option value="{{ $lga }}" {{ request('lga') == $lga ? 'selected' : '' }}>{{ $lga }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select name="asset_type" class="form-select">
                                    <option value="">All Asset Types</option>
                                    @foreach(['School Building', 'Health Center/Clinic', 'Borehole/Water Point', 'Road/Bridge', 'Government Office', 'Community Center', 'Market', 'Power/Electricity Infrastructure', 'Agricultural Facility', 'Sports Facility', 'Drainage/Canal', 'Street Light', 'Public Toilet', 'Culvert', 'Park/Recreation Area', 'Police Post', 'Fire Station', 'Other'] as $type)
                                        <option value="{{ $type }}" {{ request('asset_type') == $type ? 'selected' : '' }}>{{ $type }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="situation_status" class="form-select">
                                    <option value="">All Statuses</option>
                                    @foreach(['Under Construction', 'Completed', 'Abandoned', 'Damaged', 'Needs Maintenance', 'Needs Renovation', 'Operational', 'Non-Operational', 'Partially Operational'] as $status)
                                        <option value="{{ $status }}" {{ request('situation_status') == $status ? 'selected' : '' }}>{{ $status }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="condition" class="form-select">
                                    <option value="">All Conditions</option>
                                    @foreach(['Excellent', 'Good', 'Fair', 'Poor', 'Very Poor', 'Dilapidated'] as $condition)
                                        <option value="{{ $condition }}" {{ request('condition') == $condition ? 'selected' : '' }}>{{ $condition }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-outline-primary w-100">
                                    <i class="fas fa-filter"></i> Filter
                                </button>
                            </div>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>ID</th>
                                    <th>Asset Name</th>
                                    <th>Type</th>
                                    <th>Location</th>
                                    <th>Status</th>
                                    <th>Condition</th>
                                    <th>Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($reports as $report)
                                    <tr>
                                        <td>{{ $report->id }}</td>
                                        <td>
                                            <strong>{{ $report->asset_name }}</strong>
                                            @if($report->asset_id)
                                                <br><small class="text-muted">ID: {{ $report->asset_id }}</small>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-info">{{ $report->asset_type }}</span>
                                        </td>
                                        <td>
                                            <strong>{{ $report->ward }}, {{ $report->lga }}</strong>
                                            <br><small class="text-muted">Katsina State</small>
                                        </td>
                                        <td>
                                            @php
                                                $statusClass = match($report->situation_status) {
                                                    'Operational' => 'success',
                                                    'Damaged', 'Abandoned' => 'danger',
                                                    'Needs Maintenance', 'Needs Renovation' => 'warning',
                                                    'Under Construction', 'Partially Operational' => 'info',
                                                    default => 'secondary'
                                                };
                                            @endphp
                                            <span class="badge bg-{{ $statusClass }}">{{ $report->situation_status }}</span>
                                        </td>
                                        <td>
                                            @php
                                                $conditionClass = match($report->condition) {
                                                    'Excellent', 'Good' => 'success',
                                                    'Fair' => 'warning',
                                                    'Poor', 'Very Poor', 'Dilapidated' => 'danger',
                                                    default => 'secondary'
                                                };
                                            @endphp
                                            <span class="badge bg-{{ $conditionClass }}">{{ $report->condition }}</span>
                                        </td>
                                        <td>
                                            {{ \Carbon\Carbon::parse($report->created_at)->format('M d, Y') }}
                                            <br><small class="text-muted">{{ \Carbon\Carbon::parse($report->created_at)->format('H:i') }}</small>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('asset-reports.show', $report) }}" class="btn btn-sm btn-outline-info" title="View">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('asset-reports.edit', $report) }}" class="btn btn-sm btn-outline-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('asset-reports.destroy', $report) }}" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this report?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center py-4">
                                            <i class="fas fa-inbox text-muted fa-3x mb-3 d-block"></i>
                                            <p class="text-muted">No asset reports found.</p>
                                            <a href="{{ route('asset-reports.create') }}" class="btn btn-primary">
                                                <i class="fas fa-plus"></i> Add First Report
                                            </a>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-4">
                        {{ $reports->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection