@extends('layouts.main') 

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">
                        <i class="fas fa-file-alt"></i> Asset Report Details - #{{ $report->id }}
                    </h4>
                    <div>
                        <a href="{{ route('asset-reports.edit', $report) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('asset-reports.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Header Card -->
                        <div class="col-md-12 mb-4">
                            <div class="card bg-gradient-primary text-white">
                                <div class="card-body">
                                    <div class="row align-items-center">
                                        <div class="col-md-8">
                                            <h3 class="mb-1">{{ $report->asset_name }}</h3>
                                            <p class="mb-0">
                                                <span class="badge bg-light text-dark">{{ $report->asset_type }}</span>
                                                @if($report->asset_id)
                                                    <span class="badge bg-light text-dark">ID: {{ $report->asset_id }}</span>
                                                @endif
                                            </p>
                                        </div>
                                        <div class="col-md-4 text-end">
                                            <small>Reported on</small>
                                            <h5>{{ \Carbon\Carbon::parse($report->created_at)->format('M d, Y') }}</h5>
                                            <small>{{ \Carbon\Carbon::parse($report->created_at)->format('H:i') }}</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Location Information -->
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light h-100">
                                <div class="card-header bg-info text-white">
                                    <h6 class="mb-0"><i class="fas fa-map-marker-alt"></i> Location Information</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td><strong>State:</strong></td>
                                            <td>{{ $report->state }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>LGA:</strong></td>
                                            <td>{{ $report->lga }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Ward:</strong></td>
                                            <td>{{ $report->ward }}</td>
                                        </tr>
                                        @if($report->specific_location)
                                        <tr>
                                            <td><strong>Specific Location:</strong></td>
                                            <td>{{ $report->specific_location }}</td>
                                        </tr>
                                        @endif
                                        @if($report->latitude && $report->longitude)
                                        <tr>
                                            <td><strong>Coordinates:</strong></td>
                                            <td>
                                                {{ $report->latitude }}, {{ $report->longitude }}
                                                <a href="https://www.google.com/maps?q={{ $report->latitude }},{{ $report->longitude }}" 
                                                   target="_blank" class="btn btn-sm btn-outline-primary ms-2">
                                                    <i class="fas fa-map"></i> View on Map
                                                </a>
                                            </td>
                                        </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Status and Condition -->
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light h-100">
                                <div class="card-header bg-warning text-white">
                                    <h6 class="mb-0"><i class="fas fa-info-circle"></i> Status & Condition</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td><strong>Situation Status:</strong></td>
                                            <td>
                                                @php
                                                    $statusClass = match($report->situation_status) {
                                                        'Operational' => 'success',
                                                        'Damaged', 'Abandoned' => 'danger',
                                                        'Needs Maintenance', 'Needs Renovation' => 'warning',
                                                        'Under Construction', 'Partially Operational' => 'info',
                                                        default => 'secondary'
                                                    };
                                                @endphp
                                                <span class="badge bg-{{ $statusClass }}">{{ $report->situation_status }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Condition:</strong></td>
                                            <td>
                                                @php
                                                    $conditionClass = match($report->condition) {
                                                        'Excellent', 'Good' => 'success',
                                                        'Fair' => 'warning',
                                                        'Poor', 'Very Poor', 'Dilapidated' => 'danger',
                                                        default => 'secondary'
                                                    };
                                                @endphp
                                                <span class="badge bg-{{ $conditionClass }}">{{ $report->condition }}</span>
                                            </td>
                                        </tr>
                                        @if($report->completion_percentage)
                                        <tr>
                                            <td><strong>Completion:</strong></td>
                                            <td>
                                                <div class="progress">
                                                    <div class="progress-bar" role="progressbar" 
                                                         style="width: {{ $report->completion_percentage }}%">
                                                        {{ $report->completion_percentage }}%
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        @endif
                                        @if($report->damage_level)
                                        <tr>
                                            <td><strong>Damage Level:</strong></td>
                                            <td>
                                                @php
                                                    $damageClass = match($report->damage_level) {
                                                        'No Damage' => 'success',
                                                        'Minor Damage' => 'info',
                                                        'Moderate Damage' => 'warning',
                                                        'Severe Damage', 'Complete Damage' => 'danger',
                                                        default => 'secondary'
                                                    };
                                                @endphp
                                                <span class="badge bg-{{ $damageClass }}">{{ $report->damage_level }}</span>
                                            </td>
                                        </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Description -->
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header bg-primary text-white">
                                    <h6 class="mb-0"><i class="fas fa-file-alt"></i> Description</h6>
                                </div>
                                <div class="card-body">
                                    <p class="mb-0">{{ $report->description }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Issues -->
                        @if($report->issues)
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header bg-danger text-white">
                                    <h6 class="mb-0"><i class="fas fa-exclamation-triangle"></i> Issues & Concerns</h6>
                                </div>
                                <div class="card-body">
                                    <p class="mb-0">{{ $report->issues }}</p>
                                </div>
                            </div>
                        </div>
                        @endif

                        <!-- Photo Evidence -->
                        @if($report->photo_uris)
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header bg-success text-white">
                                    <h6 class="mb-0"><i class="fas fa-camera"></i> Photo Evidence</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row g-3">
                                        @foreach(explode(',', $report->photo_uris) as $photo)
                                            <div class="col-md-3">
                                                <a href="{{ $photo }}" target="_blank">
                                                    <img src="{{ $photo }}" class="img-fluid rounded shadow-sm" 
                                                         style="width: 100%; height: 200px; object-fit: cover;">
                                                </a>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif

                        <!-- Reported By -->
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header bg-secondary text-white">
                                    <h6 class="mb-0"><i class="fas fa-user"></i> Report Information</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <small class="text-muted">Reported By</small>
                                            <p class="mb-0"><strong>{{ $report->userId }}</strong></p>
                                        </div>
                                        <div class="col-md-4">
                                            <small class="text-muted">Report Date</small>
                                            <p class="mb-0"><strong>{{ \Carbon\Carbon::createFromTimestamp($report->report_date / 1000)->format('M d, Y H:i') }}</strong></p>
                                        </div>
                                        <div class="col-md-4">
                                            <small class="text-muted">Sync Status</small>
                                            <p class="mb-0">
                                                @if($report->isSync)
                                                    <span class="badge bg-success"><i class="fas fa-cloud-upload-alt"></i> Synced</span>
                                                @else
                                                    <span class="badge bg-warning"><i class="fas fa-cloud"></i> Pending</span>
                                                @endif
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="col-md-12">
                            <div class="d-flex gap-2 justify-content-end">
                                <a href="{{ route('asset-reports.edit', $report) }}" class="btn btn-warning">
                                    <i class="fas fa-edit"></i> Edit Report
                                </a>
                                <button type="button" class="btn btn-info" onclick="window.print()">
                                    <i class="fas fa-print"></i> Print Report
                                </button>
                                <form action="{{ route('asset-reports.destroy', $report) }}" method="POST" style="display: inline;" 
                                      onsubmit="return confirm('Are you sure you want to delete this report? This action cannot be undone.')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger">
                                        <i class="fas fa-trash"></i> Delete Report
                                    </button>
                                </form>
                                <a href="{{ route('asset-reports.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-list"></i> Back to List
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
@media print {
    .btn, .card-header .btn, form[method="POST"] {
        display: none !important;
    }
    .card {
        border: 1px solid #ddd !important;
        box-shadow: none !important;
    }
}
</style>
@endsection