@extends('layouts.main') 

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Incident Reports</h4>
                    <div>
                        <a href="{{ route('incidents.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Register New Incident
                        </a>
                        <a href="{{ route('incidents.export') }}" class="btn btn-success">
                            <i class="fas fa-download"></i> Export CSV
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <!-- Filter Form -->
                    <form method="GET" action="{{ route('incidents.index') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <input type="text" name="region" class="form-control" placeholder="Filter by Region" value="{{ request('region') }}">
                            </div>
                            <div class="col-md-3">
                                <input type="text" name="category" class="form-control" placeholder="Filter by Category" value="{{ request('category') }}">
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="start_date" class="form-control" value="{{ request('start_date') }}">
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="end_date" class="form-control" value="{{ request('end_date') }}">
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-outline-primary w-100">Filter</button>
                            </div>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Location</th>
                                    <th>Category</th>
                                    <th>Casualties</th>
                                    <th>Source</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($incidents as $incident)
                                    <tr>
                                        <td>{{ $incident->id }}</td>
                                        <td>
                                            {{ $incident->day }}/{{ $incident->month }}/{{ $incident->year }}
                                            <br><small class="text-muted">{{ $incident->hour }}</small>
                                        </td>
                                        <td>
                                            <strong>{{ $incident->city_town }}, {{ $incident->state }}</strong>
                                            <br><small class="text-muted">{{ $incident->country }}</small>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">{{ $incident->incident_category }}</span>
                                        </td>
                                        <td>
                                            @if($incident->deaths > 0)
                                                <span class="badge bg-danger">{{ $incident->deaths }} Deaths</span>
                                            @endif
                                            @if($incident->injured > 0)
                                                <span class="badge bg-warning">{{ $incident->injured }} Injured</span>
                                            @endif
                                            @if($incident->affected > 0)
                                                <span class="badge bg-secondary">{{ $incident->affected }} Affected</span>
                                            @endif
                                        </td>
                                        <td>{{ Str::limit($incident->source, 30) }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('incidents.show', $incident) }}" class="btn btn-sm btn-outline-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('incidents.edit', $incident) }}" class="btn btn-sm btn-outline-warning">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('incidents.destroy', $incident) }}" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this incident?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">No incidents found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        {{ $incidents->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection