@extends('layouts.main') 

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Incident Details - #{{ $incident->id }}</h4>
                    <div>
                        <a href="{{ route('incidents.edit', $incident) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('incidents.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Date and Time Information -->
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-calendar"></i> Date & Time Information</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td><strong>Date:</strong></td>
                                            <td>{{ $incident->day }}/{{ $incident->month }}/{{ $incident->year }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Time:</strong></td>
                                            <td>{{ $incident->hour }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Recorded:</strong></td>
                                            <td>{{ $incident->created_at->format('M d, Y H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Location Information -->
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-map-marker-alt"></i> Location Information</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td><strong>Region:</strong></td>
                                            <td>{{ $incident->region }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Country:</strong></td>
                                            <td>{{ $incident->country }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>State:</strong></td>
                                            <td>{{ $incident->state }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>LGA:</strong></td>
                                            <td>{{ $incident->local_government }}</td>
                                        </tr>
                                        <tr>
                                            <td><strong>City/Town:</strong></td>
                                            <td>{{ $incident->city_town }}</td>
                                        </tr>
                                        @if($incident->village)
                                        <tr>
                                            <td><strong>Village:</strong></td>
                                            <td>{{ $incident->village }}</td>
                                        </tr>
                                        @endif
                                        @if($incident->sub_division_block)
                                        <tr>
                                            <td><strong>Sub Division/Block:</strong></td>
                                            <td>{{ $incident->sub_division_block }}</td>
                                        </tr>
                                        @endif
                                        @if($incident->road_exact_location)
                                        <tr>
                                            <td><strong>Exact Location:</strong></td>
                                            <td>{{ $incident->road_exact_location }}</td>
                                        </tr>
                                        @endif
                                        @if($incident->latitude && $incident->longitude)
                                        <tr>
                                            <td><strong>Coordinates:</strong></td>
                                            <td>{{ $incident->latitude }}, {{ $incident->longitude }}</td>
                                        </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Incident Details -->
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-exclamation-triangle"></i> Incident Details</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td><strong>Category:</strong></td>
                                            <td><span class="badge bg-info">{{ $incident->incident_category }}</span></td>
                                        </tr>
                                        @if($incident->main_victim)
                                        <tr>
                                            <td><strong>Main Victim:</strong></td>
                                            <td>{{ $incident->main_victim }}</td>
                                        </tr>
                                        @endif
                                        @if($incident->perpetrator)
                                        <tr>
                                            <td><strong>Perpetrator:</strong></td>
                                            <td>{{ $incident->perpetrator }}</td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <td><strong>Source:</strong></td>
                                            <td>{{ $incident->source }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Involvement -->
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-users"></i> Involvement</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" {{ $incident->government_involve ? 'checked' : '' }} disabled>
                                                <label class="form-check-label">Government Involve</label>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" {{ $incident->military ? 'checked' : '' }} disabled>
                                                <label class="form-check-label">Military</label>
                                            </div>
                                        </div>
                                    </div>
                                    @if($incident->civilian)
                                    <div class="mt-2">
                                        <strong>Civilian:</strong> {{ $incident->civilian }}
                                    </div>
                                    @endif
                                    @if($incident->nsag)
                                    <div class="mt-2">
                                        <strong>NSAG:</strong> {{ $incident->nsag }}
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Casualties -->
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-heart-broken"></i> Casualties</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-md-4">
                                            <div class="p-3 bg-danger text-white rounded">
                                                <h3 class="mb-0">{{ $incident->deaths }}</h3>
                                                <small>Deaths</small>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="p-3 bg-warning text-white rounded">
                                                <h3 class="mb-0">{{ $incident->injured }}</h3>
                                                <small>Injured</small>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="p-3 bg-secondary text-white rounded">
                                                <h3 class="mb-0">{{ $incident->affected }}</h3>
                                                <small>Affected</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Additional Information -->
                        @if($incident->action_taken || $incident->by_who || $incident->time_before_attack)
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-info-circle"></i> Additional Information</h6>
                                </div>
                                <div class="card-body">
                                    @if($incident->action_taken)
                                    <div class="mb-2">
                                        <strong>Action Taken:</strong> {{ $incident->action_taken }}
                                    </div>
                                    @endif
                                    @if($incident->by_who)
                                    <div class="mb-2">
                                        <strong>By Who:</strong> {{ $incident->by_who }}
                                    </div>
                                    @endif
                                    @if($incident->time_before_attack)
                                    <div class="mb-2">
                                        <strong>Time Before Attack:</strong>
                                        <p class="mt-1">{{ $incident->time_before_attack }}</p>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endif

                        <!-- Narrative -->
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-file-alt"></i> Brief Narrative</h6>
                                </div>
                                <div class="card-body">
                                    <p>{{ $incident->brief_narrative }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Comments -->
                        @if($incident->comment)
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-comments"></i> Comments</h6>
                                </div>
                                <div class="card-body">
                                    <p>{{ $incident->comment }}</p>
                                </div>
                            </div>
                        </div>
                        @endif

                        <!-- Map Section (if coordinates available) -->
                        @if($incident->latitude && $incident->longitude)
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-map"></i> Location Map</h6>
                                </div>
                                <div class="card-body">
                                    <div id="map" style="height: 300px; width: 100%;"></div>
                                    <p class="mt-2 text-muted">
                                        <small>Coordinates: {{ $incident->latitude }}, {{ $incident->longitude }}</small>
                                    </p>
                                </div>
                            </div>
                        </div>
                        @endif

                        <!-- Action Buttons -->
                        <div class="col-md-12">
                            <div class="d-flex gap-2 justify-content-end">
                                <a href="{{ route('incidents.edit', $incident) }}" class="btn btn-warning">
                                    <i class="fas fa-edit"></i> Edit Incident
                                </a>
                                <form action="{{ route('incidents.destroy', $incident) }}" method="POST" style="display: inline;" 
                                      onsubmit="return confirm('Are you sure you want to delete this incident? This action cannot be undone.')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger">
                                        <i class="fas fa-trash"></i> Delete Incident
                                    </button>
                                </form>
                                <a href="{{ route('incidents.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-list"></i> Back to List
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@if($incident->latitude && $incident->longitude)
<script>
// Simple map implementation using OpenStreetMap
document.addEventListener('DOMContentLoaded', function() {
    const mapDiv = document.getElementById('map');
    if (mapDiv) {
        // You can implement a proper map here using Leaflet or Google Maps
        // For now, we'll show a simple placeholder with coordinates
        mapDiv.innerHTML = `
            <div class="d-flex align-items-center justify-content-center h-100 bg-secondary text-white">
                <div class="text-center">
                    <i class="fas fa-map-marker-alt fa-3x mb-2"></i>
                    <p>Location: {{ $incident->latitude }}, {{ $incident->longitude }}</p>
                    <small>Map integration can be added with Leaflet or Google Maps API</small>
                </div>
            </div>
        `;
    }
});
</script>
@endif
@endsection