<?php

use Illuminate\Http\Request;
use App\Http\Controllers\Api\V4\Auth\AuthController;
use App\Http\Controllers\Api\V4\{
    AssetReportController,
    CustomerController,
    DeliveryController,
    DiscountController,
    InventoryController,
    ProductController,
    SalesController,
    StoreController,
    TableController,
    UserController,
    PurchaseController,
    ExpensesController,
    SupplierController,
    OnlineOrderController,
    IncidentController
};
/*
|--------------------------------------------------------------------------
| API Routes  V1 /api
|--------------------------------------------------------------------------
|
*/


Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});




    //Auth
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/register', [AuthController::class, 'register']);

       Route::get('asset-reports', [AssetReportController::class, 'getReports']);
    Route::post('asset-reports/sync', [AssetReportController::class, 'syncReport']);
    Route::delete('asset-reports/{localId}', [AssetReportController::class, 'deleteReport']);
    Route::get('asset-reports/{localId}', [AssetReportController::class, 'getReportById']);
    Route::get('asset-reports/statistics', [AssetReportController::class, 'getStatistics']);
    Route::get('asset-reports/filter', [AssetReportController::class, 'filterReports']);

 
    // User
    Route::post('/user/sync', [UserController::class, 'sync']);
    Route::get('/user/get-updates', [UserController::class, 'getUser']); 
    Route::get('/plans', [UserController::class, 'getPlans']);
    Route::get('/user/profile', [UserController::class, 'getUserProfile']);
    Route::post('/user/profile/update', [UserController::class, 'updateUserProfile']);

    //Staff 
    Route::post('/staff/create', [UserController::class, 'createStaff']); 
    Route::get('/staff/details', [UserController::class, 'getStaffs']);  
    Route::post('/staff/update', [UserController::class, 'updateStaff']);
    Route::post('/staff/delete', [UserController::class, 'blockUser']);
    Route::get('/staff/search', [UserController::class, 'searchUsers']);
 
   //transactions
    Route::get('/transactions/history', [OnlineOrderController::class, 'getTransactionHistory']);
    

    // SUPPLIER ROUTES
    Route::prefix('supplier')->group(function () {
        Route::post('/sync', [SupplierController::class, 'sync']);
        Route::get('/get-updates', [SupplierController::class, 'getUpdates']);
        Route::get('/index', [SupplierController::class, 'getSuppliers']);

    });
 








