 

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0"><?php echo e(isset($incident) ? 'Edit Incident' : 'Register New Incident'); ?></h4>
                    <a href="<?php echo e(route('incidents.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to List
                    </a>
                </div>

                <div class="card-body">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(isset($incident) ? route('incidents.update', $incident) : route('incidents.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php if(isset($incident)): ?>
                            <?php echo method_field('PUT'); ?>
                        <?php endif; ?>

                        <!-- Date and Time Section -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">Date & Time Information</h5>
                            </div>
                            <div class="col-md-3">
                                <label for="year" class="form-label">Year <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="year" name="year" 
                                       value="<?php echo e(old('year', $incident->year ?? date('Y'))); ?>" min="1900" max="<?php echo e(date('Y')); ?>" required>
                            </div>
                            <div class="col-md-3">
                                <label for="month" class="form-label">Month <span class="text-danger">*</span></label>
                                <select class="form-control" id="month" name="month" required>
                                    <option value="">Select Month</option>
                                    <?php $__currentLoopData = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($month); ?>" <?php echo e(old('month', $incident->month ?? '') == $month ? 'selected' : ''); ?>><?php echo e($month); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="day" class="form-label">Day <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="day" name="day" 
                                       value="<?php echo e(old('day', $incident->day ?? '')); ?>" min="1" max="31" required>
                            </div>
                            <div class="col-md-3">
                                <label for="hour" class="form-label">Hour <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="hour" name="hour" 
                                       value="<?php echo e(old('hour', $incident->hour ?? '')); ?>" placeholder="e.g., 14:30" required>
                            </div>
                        </div>

                        <!-- Location Section -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">Location Information</h5>
                            </div>
                            <div class="col-md-4">
                                <label for="region" class="form-label">Region <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="region" name="region" 
                                       value="<?php echo e(old('region', $incident->region ?? '')); ?>" required>
                            </div>
                            <div class="col-md-4">
                                <label for="country" class="form-label">Country <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="country" name="country" 
                                       value="<?php echo e(old('country', $incident->country ?? '')); ?>" required>
                            </div>
                            <div class="col-md-4">
                                <label for="state" class="form-label">State <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="state" name="state" 
                                       value="<?php echo e(old('state', $incident->state ?? '')); ?>" required>
                            </div>
                            <div class="col-md-4">
                                <label for="local_government" class="form-label">Local Government <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="local_government" name="local_government" 
                                       value="<?php echo e(old('local_government', $incident->local_government ?? '')); ?>" required>
                            </div>
                            <div class="col-md-4">
                                <label for="city_town" class="form-label">City/Town <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="city_town" name="city_town" 
                                       value="<?php echo e(old('city_town', $incident->city_town ?? '')); ?>" required>
                            </div>
                            <div class="col-md-4">
                                <label for="village" class="form-label">Village</label>
                                <input type="text" class="form-control" id="village" name="village" 
                                       value="<?php echo e(old('village', $incident->village ?? '')); ?>">
                            </div>
                            <div class="col-md-6">
                                <label for="sub_division_block" class="form-label">Sub Division/Block</label>
                                <input type="text" class="form-control" id="sub_division_block" name="sub_division_block" 
                                       value="<?php echo e(old('sub_division_block', $incident->sub_division_block ?? '')); ?>">
                            </div>
                            <div class="col-md-6">
                                <label for="road_exact_location" class="form-label">Road/Exact Location</label>
                                <input type="text" class="form-control" id="road_exact_location" name="road_exact_location" 
                                       value="<?php echo e(old('road_exact_location', $incident->road_exact_location ?? '')); ?>">
                            </div>
                            <div class="col-md-6">
                                <label for="latitude" class="form-label">Latitude</label>
                                <input type="number" step="any" class="form-control" id="latitude" name="latitude" 
                                       value="<?php echo e(old('latitude', $incident->latitude ?? '')); ?>" placeholder="e.g., 9.0579">
                            </div>
                            <div class="col-md-6">
                                <label for="longitude" class="form-label">Longitude</label>
                                <input type="number" step="any" class="form-control" id="longitude" name="longitude" 
                                       value="<?php echo e(old('longitude', $incident->longitude ?? '')); ?>" placeholder="e.g., 8.6753">
                            </div>
                        </div>

                        <!-- Incident Details Section -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">Incident Details</h5>
                            </div>
                            <div class="col-md-6">
                                <label for="incident_category" class="form-label">Incident Category <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="incident_category" name="incident_category" 
                                       value="<?php echo e(old('incident_category', $incident->incident_category ?? '')); ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label for="main_victim" class="form-label">Main Victim</label>
                                <input type="text" class="form-control" id="main_victim" name="main_victim" 
                                       value="<?php echo e(old('main_victim', $incident->main_victim ?? '')); ?>">
                            </div>
                        </div>

                        <!-- Involvement Section -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">Involvement</h5>
                            </div>
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="government_involve" name="government_involve" value="1"
                                           <?php echo e(old('government_involve', $incident->government_involve ?? false) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="government_involve">
                                        Government Involve
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="civilian" class="form-label">Civilian</label>
                                <input type="text" class="form-control" id="civilian" name="civilian" 
                                       value="<?php echo e(old('civilian', $incident->civilian ?? '')); ?>">
                            </div>
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="military" name="military" value="1"
                                           <?php echo e(old('military', $incident->military ?? false) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="military">
                                        Military
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="nsag" class="form-label">NSAG</label>
                                <input type="text" class="form-control" id="nsag" name="nsag" 
                                       value="<?php echo e(old('nsag', $incident->nsag ?? '')); ?>">
                            </div>
                        </div>

                        <!-- Casualties Section -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">Casualties</h5>
                            </div>
                            <div class="col-md-4">
                                <label for="deaths" class="form-label"># Death <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="deaths" name="deaths" 
                                       value="<?php echo e(old('deaths', $incident->deaths ?? 0)); ?>" min="0" required>
                            </div>
                            <div class="col-md-4">
                                <label for="injured" class="form-label"># Injured <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="injured" name="injured" 
                                       value="<?php echo e(old('injured', $incident->injured ?? 0)); ?>" min="0" required>
                            </div>
                            <div class="col-md-4">
                                <label for="affected" class="form-label"># Affected <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="affected" name="affected" 
                                       value="<?php echo e(old('affected', $incident->affected ?? 0)); ?>" min="0" required>
                            </div>
                        </div>

                        <!-- Additional Information Section -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">Additional Information</h5>
                            </div>
                            <div class="col-md-6">
                                <label for="perpetrator" class="form-label">Perpetrator</label>
                                <input type="text" class="form-control" id="perpetrator" name="perpetrator" 
                                       value="<?php echo e(old('perpetrator', $incident->perpetrator ?? '')); ?>">
                            </div>
                            <div class="col-md-6">
                                <label for="source" class="form-label">Source <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="source" name="source" 
                                       value="<?php echo e(old('source', $incident->source ?? '')); ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label for="action_taken" class="form-label">Action Taken</label>
                                <input type="text" class="form-control" id="action_taken" name="action_taken" 
                                       value="<?php echo e(old('action_taken', $incident->action_taken ?? '')); ?>">
                            </div>
                            <div class="col-md-6">
                                <label for="by_who" class="form-label">By Who</label>
                                <input type="text" class="form-control" id="by_who" name="by_who" 
                                       value="<?php echo e(old('by_who', $incident->by_who ?? '')); ?>">
                            </div>
                            <div class="col-12">
                                <label for="time_before_attack" class="form-label">Time Before the Attack</label>
                                <textarea class="form-control" id="time_before_attack" name="time_before_attack" rows="3"><?php echo e(old('time_before_attack', $incident->time_before_attack ?? '')); ?></textarea>
                            </div>
                        </div>

                        <!-- Narrative Section -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">Narrative</h5>
                            </div>
                            <div class="col-12">
                                <label for="brief_narrative" class="form-label">Brief Narrative <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="brief_narrative" name="brief_narrative" rows="5" required><?php echo e(old('brief_narrative', $incident->brief_narrative ?? '')); ?></textarea>
                            </div>
                            <div class="col-12">
                                <label for="comment" class="form-label">Comment</label>
                                <textarea class="form-control" id="comment" name="comment" rows="3"><?php echo e(old('comment', $incident->comment ?? '')); ?></textarea>
                            </div>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save"></i> <?php echo e(isset($incident) ? 'Update Incident' : 'Submit Incident'); ?>

                                    </button>
                                    <a href="<?php echo e(route('incidents.index')); ?>" class="btn btn-secondary">
                                        <i class="fas fa-times"></i> Cancel
                                    </a>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-update day options based on month/year selection
    const monthSelect = document.getElementById('month');
    const yearInput = document.getElementById('year');
    const dayInput = document.getElementById('day');
    
    function updateDayMax() {
        const month = monthSelect.value;
        const year = parseInt(yearInput.value) || new Date().getFullYear();
        
        if (month) {
            const monthIndex = ['January', 'February', 'March', 'April', 'May', 'June', 
                              'July', 'August', 'September', 'October', 'November', 'December'].indexOf(month);
            const daysInMonth = new Date(year, monthIndex + 1, 0).getDate();
            dayInput.max = daysInMonth;
            
            // Reset day if it's greater than the maximum for the selected month
            if (parseInt(dayInput.value) > daysInMonth) {
                dayInput.value = daysInMonth;
            }
        }
    }
    
    monthSelect.addEventListener('change', updateDayMax);
    yearInput.addEventListener('change', updateDayMax);
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/montela/resources/views/incidents/create.blade.php ENDPATH**/ ?>