 

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">
                        <i class="fas fa-<?php echo e(isset($report) ? 'edit' : 'plus'); ?>"></i>
                        <?php echo e(isset($report) ? 'Edit Asset Report' : 'Add New Asset Report'); ?>

                    </h4>
                    <a href="<?php echo e(route('asset-reports.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to List
                    </a>
                </div>

                <div class="card-body">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(isset($report) ? route('asset-reports.update', $report) : route('asset-reports.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php if(isset($report)): ?>
                            <?php echo method_field('PUT'); ?>
                        <?php endif; ?>

                        <!-- Location Information -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-map-marker-alt"></i> Location Information
                                </h5>
                            </div>
                            <div class="col-md-6">
                                <label for="lga" class="form-label">LGA <span class="text-danger">*</span></label>
                                <select class="form-select" id="lga" name="lga" required>
                                    <option value="">Select LGA</option>
                                    <?php $__currentLoopData = ['Bakori', 'Batagarawa', 'Batsari', 'Baure', 'Bindawa', 'Charanchi', 'Dandume', 'Danja', 'Dan Musa', 'Daura', 'Dutsi', 'Dutsin Ma', 'Faskari', 'Funtua', 'Ingawa', 'Jibia', 'Kafur', 'Kaita', 'Kankara', 'Kankia', 'Katsina', 'Kurfi', 'Kusada', "Mai'Adua", 'Malumfashi', 'Mani', 'Mashi', 'Matazu', 'Musawa', 'Rimi', 'Sabuwa', 'Safana', 'Sandamu', 'Zango']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lga): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($lga); ?>" <?php echo e(old('lga', $report->lga ?? '') == $lga ? 'selected' : ''); ?>><?php echo e($lga); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="ward" class="form-label">Ward <span class="text-danger">*</span></label>
                                <select class="form-select" id="ward" name="ward" required>
                                    <option value="">Select Ward</option>
                                </select>
                            </div>
                            <div class="col-12">
                                <label for="specific_location" class="form-label">Specific Location</label>
                                <input type="text" class="form-control" id="specific_location" name="specific_location" 
                                       value="<?php echo e(old('specific_location', $report->specific_location ?? '')); ?>" 
                                       placeholder="Street name, landmark, or additional details">
                            </div>
                            <div class="col-md-6">
                                <label for="latitude" class="form-label">Latitude</label>
                                <input type="text" class="form-control" id="latitude" name="latitude" 
                                       value="<?php echo e(old('latitude', $report->latitude ?? '')); ?>" 
                                       placeholder="e.g., 12.3456">
                            </div>
                            <div class="col-md-6">
                                <label for="longitude" class="form-label">Longitude</label>
                                <input type="text" class="form-control" id="longitude" name="longitude" 
                                       value="<?php echo e(old('longitude', $report->longitude ?? '')); ?>" 
                                       placeholder="e.g., 7.6543">
                            </div>
                        </div>

                        <!-- Asset Information -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-building"></i> Asset Information
                                </h5>
                            </div>
                            <div class="col-md-6">
                                <label for="asset_type" class="form-label">Asset Type <span class="text-danger">*</span></label>
                                <select class="form-select" id="asset_type" name="asset_type" required>
                                    <option value="">Select Asset Type</option>
                                    <?php $__currentLoopData = ['School Building', 'Health Center/Clinic', 'Borehole/Water Point', 'Road/Bridge', 'Government Office', 'Community Center', 'Market', 'Power/Electricity Infrastructure', 'Agricultural Facility', 'Sports Facility', 'Drainage/Canal', 'Street Light', 'Public Toilet', 'Culvert', 'Park/Recreation Area', 'Police Post', 'Fire Station', 'Other']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type); ?>" <?php echo e(old('asset_type', $report->asset_type ?? '') == $type ? 'selected' : ''); ?>><?php echo e($type); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="asset_name" class="form-label">Asset Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="asset_name" name="asset_name" 
                                       value="<?php echo e(old('asset_name', $report->asset_name ?? '')); ?>" required
                                       placeholder="e.g., Katsina Central Primary School">
                            </div>
                            <div class="col-md-12">
                                <label for="asset_id" class="form-label">Asset ID</label>
                                <input type="text" class="form-control" id="asset_id" name="asset_id" 
                                       value="<?php echo e(old('asset_id', $report->asset_id ?? '')); ?>"
                                       placeholder="Unique identifier (optional)">
                            </div>
                        </div>

                        <!-- Current Situation -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-info-circle"></i> Current Situation
                                </h5>
                            </div>
                            <div class="col-md-6">
                                <label for="situation_status" class="form-label">Situation Status <span class="text-danger">*</span></label>
                                <select class="form-select" id="situation_status" name="situation_status" required>
                                    <option value="">Select Status</option>
                                    <?php $__currentLoopData = ['Under Construction', 'Completed', 'Abandoned', 'Damaged', 'Needs Maintenance', 'Needs Renovation', 'Operational', 'Non-Operational', 'Partially Operational']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($status); ?>" <?php echo e(old('situation_status', $report->situation_status ?? '') == $status ? 'selected' : ''); ?>><?php echo e($status); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="condition" class="form-label">Condition <span class="text-danger">*</span></label>
                                <select class="form-select" id="condition" name="condition" required>
                                    <option value="">Select Condition</option>
                                    <?php $__currentLoopData = ['Excellent', 'Good', 'Fair', 'Poor', 'Very Poor', 'Dilapidated']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $condition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($condition); ?>" <?php echo e(old('condition', $report->condition ?? '') == $condition ? 'selected' : ''); ?>><?php echo e($condition); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="completion_percentage" class="form-label">Completion Percentage</label>
                                <input type="number" class="form-control" id="completion_percentage" name="completion_percentage" 
                                       value="<?php echo e(old('completion_percentage', $report->completion_percentage ?? '')); ?>" 
                                       min="0" max="100" placeholder="0-100">
                            </div>
                            <div class="col-md-6">
                                <label for="damage_level" class="form-label">Damage Level</label>
                                <select class="form-select" id="damage_level" name="damage_level">
                                    <option value="">Select Damage Level</option>
                                    <?php $__currentLoopData = ['No Damage', 'Minor Damage', 'Moderate Damage', 'Severe Damage', 'Complete Damage']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($level); ?>" <?php echo e(old('damage_level', $report->damage_level ?? '') == $level ? 'selected' : ''); ?>><?php echo e($level); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <!-- Report Details -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-file-alt"></i> Report Details
                                </h5>
                            </div>
                            <div class="col-12">
                                <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="description" name="description" rows="4" required 
                                          placeholder="Provide a detailed description of the asset and its current state"><?php echo e(old('description', $report->description ?? '')); ?></textarea>
                            </div>
                            <div class="col-12">
                                <label for="issues" class="form-label">Issues/Concerns</label>
                                <textarea class="form-control" id="issues" name="issues" rows="3" 
                                          placeholder="List any issues, concerns, or required actions"><?php echo e(old('issues', $report->issues ?? '')); ?></textarea>
                            </div>
                        </div>

                        <!-- Photo Evidence -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">
                                    <i class="fas fa-camera"></i> Photo Evidence
                                </h5>
                            </div>
                            <div class="col-12">
                                <label for="photos" class="form-label">Upload Photos</label>
                                <input type="file" class="form-control" id="photos" name="photos[]" multiple accept="image/*">
                                <small class="text-muted">You can select multiple photos (Max 5 photos, 5MB each)</small>
                                
                                <?php if(isset($report) && $report->photo_uris): ?>
                                    <div class="mt-3">
                                        <p class="mb-2"><strong>Existing Photos:</strong></p>
                                        <div class="row g-2">
                                            <?php $__currentLoopData = explode(',', $report->photo_uris); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-auto">
                                                    <img src="<?php echo e($photo); ?>" class="img-thumbnail" style="width: 100px; height: 100px; object-fit: cover;">
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save"></i> <?php echo e(isset($report) ? 'Update Report' : 'Submit Report'); ?>

                                    </button>
                                    <a href="<?php echo e(route('asset-reports.index')); ?>" class="btn btn-secondary">
                                        <i class="fas fa-times"></i> Cancel
                                    </a>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Ward data for each LGA
const wardsByLGA = {
    'Bakori': ['Bakori', 'Barde', 'Dankaba', 'Darkutchi', 'Guga', 'Kandarawa', 'Karofi', 'Kwantakwaram', 'Mai-Daji', 'Tsiga'],
    'Batagarawa': ['Bakiyawa', 'Batagarawa', 'Dandagoro', 'Dan Ali', 'Kayawa', 'Kagara', 'Mai Ruwa', 'Matsai', 'Sabontakai', 'Yammawa'],
    // Add all other LGAs and their wards here...
};

document.addEventListener('DOMContentLoaded', function() {
    const lgaSelect = document.getElementById('lga');
    const wardSelect = document.getElementById('ward');
    const savedWard = "<?php echo e(old('ward', $report->ward ?? '')); ?>";
    
    function updateWards() {
        const selectedLGA = lgaSelect.value;
        wardSelect.innerHTML = '<option value="">Select Ward</option>';
        
        if (selectedLGA && wardsByLGA[selectedLGA]) {
            wardsByLGA[selectedLGA].forEach(ward => {
                const option = document.createElement('option');
                option.value = ward;
                option.textContent = ward;
                if (ward === savedWard) {
                    option.selected = true;
                }
                wardSelect.appendChild(option);
            });
        }
    }
    
    lgaSelect.addEventListener('change', updateWards);
    
    // Initialize wards on page load
    if (lgaSelect.value) {
        updateWards();
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bybluepa/public_html/kasama.bybluepage.com/resources/views/asset_reports/form.blade.php ENDPATH**/ ?>