 

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Incident Details - #<?php echo e($incident->id); ?></h4>
                    <div>
                        <a href="<?php echo e(route('incidents.edit', $incident)); ?>" class="btn btn-warning">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="<?php echo e(route('incidents.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <!-- Date and Time Information -->
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-calendar"></i> Date & Time Information</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td><strong>Date:</strong></td>
                                            <td><?php echo e($incident->day); ?>/<?php echo e($incident->month); ?>/<?php echo e($incident->year); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Time:</strong></td>
                                            <td><?php echo e($incident->hour); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Recorded:</strong></td>
                                            <td><?php echo e($incident->created_at->format('M d, Y H:i')); ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Location Information -->
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-map-marker-alt"></i> Location Information</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td><strong>Region:</strong></td>
                                            <td><?php echo e($incident->region); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Country:</strong></td>
                                            <td><?php echo e($incident->country); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>State:</strong></td>
                                            <td><?php echo e($incident->state); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>LGA:</strong></td>
                                            <td><?php echo e($incident->local_government); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>City/Town:</strong></td>
                                            <td><?php echo e($incident->city_town); ?></td>
                                        </tr>
                                        <?php if($incident->village): ?>
                                        <tr>
                                            <td><strong>Village:</strong></td>
                                            <td><?php echo e($incident->village); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                        <?php if($incident->sub_division_block): ?>
                                        <tr>
                                            <td><strong>Sub Division/Block:</strong></td>
                                            <td><?php echo e($incident->sub_division_block); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                        <?php if($incident->road_exact_location): ?>
                                        <tr>
                                            <td><strong>Exact Location:</strong></td>
                                            <td><?php echo e($incident->road_exact_location); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                        <?php if($incident->latitude && $incident->longitude): ?>
                                        <tr>
                                            <td><strong>Coordinates:</strong></td>
                                            <td><?php echo e($incident->latitude); ?>, <?php echo e($incident->longitude); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Incident Details -->
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-exclamation-triangle"></i> Incident Details</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm table-borderless">
                                        <tr>
                                            <td><strong>Category:</strong></td>
                                            <td><span class="badge bg-info"><?php echo e($incident->incident_category); ?></span></td>
                                        </tr>
                                        <?php if($incident->main_victim): ?>
                                        <tr>
                                            <td><strong>Main Victim:</strong></td>
                                            <td><?php echo e($incident->main_victim); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                        <?php if($incident->perpetrator): ?>
                                        <tr>
                                            <td><strong>Perpetrator:</strong></td>
                                            <td><?php echo e($incident->perpetrator); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                        <tr>
                                            <td><strong>Source:</strong></td>
                                            <td><?php echo e($incident->source); ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Involvement -->
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-users"></i> Involvement</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" <?php echo e($incident->government_involve ? 'checked' : ''); ?> disabled>
                                                <label class="form-check-label">Government Involve</label>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" <?php echo e($incident->military ? 'checked' : ''); ?> disabled>
                                                <label class="form-check-label">Military</label>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if($incident->civilian): ?>
                                    <div class="mt-2">
                                        <strong>Civilian:</strong> <?php echo e($incident->civilian); ?>

                                    </div>
                                    <?php endif; ?>
                                    <?php if($incident->nsag): ?>
                                    <div class="mt-2">
                                        <strong>NSAG:</strong> <?php echo e($incident->nsag); ?>

                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Casualties -->
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-heart-broken"></i> Casualties</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-md-4">
                                            <div class="p-3 bg-danger text-white rounded">
                                                <h3 class="mb-0"><?php echo e($incident->deaths); ?></h3>
                                                <small>Deaths</small>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="p-3 bg-warning text-white rounded">
                                                <h3 class="mb-0"><?php echo e($incident->injured); ?></h3>
                                                <small>Injured</small>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="p-3 bg-secondary text-white rounded">
                                                <h3 class="mb-0"><?php echo e($incident->affected); ?></h3>
                                                <small>Affected</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Additional Information -->
                        <?php if($incident->action_taken || $incident->by_who || $incident->time_before_attack): ?>
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-info-circle"></i> Additional Information</h6>
                                </div>
                                <div class="card-body">
                                    <?php if($incident->action_taken): ?>
                                    <div class="mb-2">
                                        <strong>Action Taken:</strong> <?php echo e($incident->action_taken); ?>

                                    </div>
                                    <?php endif; ?>
                                    <?php if($incident->by_who): ?>
                                    <div class="mb-2">
                                        <strong>By Who:</strong> <?php echo e($incident->by_who); ?>

                                    </div>
                                    <?php endif; ?>
                                    <?php if($incident->time_before_attack): ?>
                                    <div class="mb-2">
                                        <strong>Time Before Attack:</strong>
                                        <p class="mt-1"><?php echo e($incident->time_before_attack); ?></p>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- Narrative -->
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-file-alt"></i> Brief Narrative</h6>
                                </div>
                                <div class="card-body">
                                    <p><?php echo e($incident->brief_narrative); ?></p>
                                </div>
                            </div>
                        </div>

                        <!-- Comments -->
                        <?php if($incident->comment): ?>
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-comments"></i> Comments</h6>
                                </div>
                                <div class="card-body">
                                    <p><?php echo e($incident->comment); ?></p>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- Map Section (if coordinates available) -->
                        <?php if($incident->latitude && $incident->longitude): ?>
                        <div class="col-md-12 mb-4">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-map"></i> Location Map</h6>
                                </div>
                                <div class="card-body">
                                    <div id="map" style="height: 300px; width: 100%;"></div>
                                    <p class="mt-2 text-muted">
                                        <small>Coordinates: <?php echo e($incident->latitude); ?>, <?php echo e($incident->longitude); ?></small>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- Action Buttons -->
                        <div class="col-md-12">
                            <div class="d-flex gap-2 justify-content-end">
                                <a href="<?php echo e(route('incidents.edit', $incident)); ?>" class="btn btn-warning">
                                    <i class="fas fa-edit"></i> Edit Incident
                                </a>
                                <form action="<?php echo e(route('incidents.destroy', $incident)); ?>" method="POST" style="display: inline;" 
                                      onsubmit="return confirm('Are you sure you want to delete this incident? This action cannot be undone.')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger">
                                        <i class="fas fa-trash"></i> Delete Incident
                                    </button>
                                </form>
                                <a href="<?php echo e(route('incidents.index')); ?>" class="btn btn-secondary">
                                    <i class="fas fa-list"></i> Back to List
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if($incident->latitude && $incident->longitude): ?>
<script>
// Simple map implementation using OpenStreetMap
document.addEventListener('DOMContentLoaded', function() {
    const mapDiv = document.getElementById('map');
    if (mapDiv) {
        // You can implement a proper map here using Leaflet or Google Maps
        // For now, we'll show a simple placeholder with coordinates
        mapDiv.innerHTML = `
            <div class="d-flex align-items-center justify-content-center h-100 bg-secondary text-white">
                <div class="text-center">
                    <i class="fas fa-map-marker-alt fa-3x mb-2"></i>
                    <p>Location: <?php echo e($incident->latitude); ?>, <?php echo e($incident->longitude); ?></p>
                    <small>Map integration can be added with Leaflet or Google Maps API</small>
                </div>
            </div>
        `;
    }
});
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bybluepa/public_html/asat.bybluepage.com/resources/views/incidents/show.blade.php ENDPATH**/ ?>