 

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0"><i class="fas fa-building"></i> Asset Reports</h4>
                    <div>
                        <a href="<?php echo e(route('asset-reports.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Add New Report
                        </a>
                        <a href="<?php echo e(route('asset-reports.export')); ?>" class="btn btn-success">
                            <i class="fas fa-download"></i> Export CSV
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <!-- Filter Form -->
                    <form method="GET" action="<?php echo e(route('asset-reports.index')); ?>" class="mb-4">
                        <div class="row g-3">
                            <div class="col-md-3">
                                <select name="lga" class="form-select">
                                    <option value="">All LGAs</option>
                                    <?php $__currentLoopData = ['Bakori', 'Batagarawa', 'Batsari', 'Baure', 'Bindawa', 'Charanchi', 'Dandume', 'Danja', 'Dan Musa', 'Daura', 'Dutsi', 'Dutsin Ma', 'Faskari', 'Funtua', 'Ingawa', 'Jibia', 'Kafur', 'Kaita', 'Kankara', 'Kankia', 'Katsina', 'Kurfi', 'Kusada', "Mai'Adua", 'Malumfashi', 'Mani', 'Mashi', 'Matazu', 'Musawa', 'Rimi', 'Sabuwa', 'Safana', 'Sandamu', 'Zango']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lga): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($lga); ?>" <?php echo e(request('lga') == $lga ? 'selected' : ''); ?>><?php echo e($lga); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select name="asset_type" class="form-select">
                                    <option value="">All Asset Types</option>
                                    <?php $__currentLoopData = ['School Building', 'Health Center/Clinic', 'Borehole/Water Point', 'Road/Bridge', 'Government Office', 'Community Center', 'Market', 'Power/Electricity Infrastructure', 'Agricultural Facility', 'Sports Facility', 'Drainage/Canal', 'Street Light', 'Public Toilet', 'Culvert', 'Park/Recreation Area', 'Police Post', 'Fire Station', 'Other']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($type); ?>" <?php echo e(request('asset_type') == $type ? 'selected' : ''); ?>><?php echo e($type); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="situation_status" class="form-select">
                                    <option value="">All Statuses</option>
                                    <?php $__currentLoopData = ['Under Construction', 'Completed', 'Abandoned', 'Damaged', 'Needs Maintenance', 'Needs Renovation', 'Operational', 'Non-Operational', 'Partially Operational']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($status); ?>" <?php echo e(request('situation_status') == $status ? 'selected' : ''); ?>><?php echo e($status); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="condition" class="form-select">
                                    <option value="">All Conditions</option>
                                    <?php $__currentLoopData = ['Excellent', 'Good', 'Fair', 'Poor', 'Very Poor', 'Dilapidated']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $condition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($condition); ?>" <?php echo e(request('condition') == $condition ? 'selected' : ''); ?>><?php echo e($condition); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-outline-primary w-100">
                                    <i class="fas fa-filter"></i> Filter
                                </button>
                            </div>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>ID</th>
                                    <th>Asset Name</th>
                                    <th>Type</th>
                                    <th>Location</th>
                                    <th>Status</th>
                                    <th>Condition</th>
                                    <th>Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($report->id); ?></td>
                                        <td>
                                            <strong><?php echo e($report->asset_name); ?></strong>
                                            <?php if($report->asset_id): ?>
                                                <br><small class="text-muted">ID: <?php echo e($report->asset_id); ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span class="badge bg-info"><?php echo e($report->asset_type); ?></span>
                                        </td>
                                        <td>
                                            <strong><?php echo e($report->ward); ?>, <?php echo e($report->lga); ?></strong>
                                            <br><small class="text-muted">Katsina State</small>
                                        </td>
                                        <td>
                                            <?php
                                                $statusClass = match($report->situation_status) {
                                                    'Operational' => 'success',
                                                    'Damaged', 'Abandoned' => 'danger',
                                                    'Needs Maintenance', 'Needs Renovation' => 'warning',
                                                    'Under Construction', 'Partially Operational' => 'info',
                                                    default => 'secondary'
                                                };
                                            ?>
                                            <span class="badge bg-<?php echo e($statusClass); ?>"><?php echo e($report->situation_status); ?></span>
                                        </td>
                                        <td>
                                            <?php
                                                $conditionClass = match($report->condition) {
                                                    'Excellent', 'Good' => 'success',
                                                    'Fair' => 'warning',
                                                    'Poor', 'Very Poor', 'Dilapidated' => 'danger',
                                                    default => 'secondary'
                                                };
                                            ?>
                                            <span class="badge bg-<?php echo e($conditionClass); ?>"><?php echo e($report->condition); ?></span>
                                        </td>
                                        <td>
                                            <?php echo e(\Carbon\Carbon::parse($report->created_at)->format('M d, Y')); ?>

                                            <br><small class="text-muted"><?php echo e(\Carbon\Carbon::parse($report->created_at)->format('H:i')); ?></small>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="<?php echo e(route('asset-reports.show', $report)); ?>" class="btn btn-sm btn-outline-info" title="View">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('asset-reports.edit', $report)); ?>" class="btn btn-sm btn-outline-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('asset-reports.destroy', $report)); ?>" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this report?')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="8" class="text-center py-4">
                                            <i class="fas fa-inbox text-muted fa-3x mb-3 d-block"></i>
                                            <p class="text-muted">No asset reports found.</p>
                                            <a href="<?php echo e(route('asset-reports.create')); ?>" class="btn btn-primary">
                                                <i class="fas fa-plus"></i> Add First Report
                                            </a>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-4">
                        <?php echo e($reports->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bybluepa/public_html/kasama.bybluepage.com/resources/views/asset_reports/index.blade.php ENDPATH**/ ?>